/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.context.EntityRowModelMapper;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.context.ResponseMapper;
import org.neo4j.ogm.context.RestModelMapper;
import org.neo4j.ogm.context.RestStatisticsModel;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.query.CypherQuery;
import org.neo4j.ogm.cypher.query.DefaultGraphModelRequest;
import org.neo4j.ogm.cypher.query.DefaultRestModelRequest;
import org.neo4j.ogm.cypher.query.DefaultRowModelRequest;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.request.RowModelRequest;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.response.model.QueryResultModel;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.session.delegates.SessionDelegate;
import org.neo4j.ogm.session.request.strategy.impl.CountStatements;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.utils.ClassUtils;

public class ExecuteQueriesDelegate
extends SessionDelegate {
    private static final Pattern WRITE_CYPHER_KEYWORDS = Pattern.compile("\\b(CREATE|MERGE|SET|DELETE|REMOVE|DROP)\\b");

    public ExecuteQueriesDelegate(Neo4jSession session) {
        super(session);
    }

    public <T> T queryForObject(Class<T> type, String cypher, Map<String, ?> parameters) {
        Iterable<T> results = this.query(type, cypher, parameters);
        int resultSize = Utils.size(results);
        if (resultSize < 1) {
            return null;
        }
        if (resultSize > 1) {
            throw new RuntimeException("Result not of expected size. Expected 1 row but found " + resultSize);
        }
        return results.iterator().next();
    }

    public <T> Iterable<T> query(Class<T> type, String cypher, Map<String, ?> parameters) {
        this.validateQuery(cypher, parameters, false);
        if (type == null || type.equals(Void.class)) {
            throw new RuntimeException("Supplied type must not be null or void.");
        }
        return this.executeAndMap(type, cypher, parameters, new EntityRowModelMapper());
    }

    @Deprecated
    public Result query(String cypher, Map<String, ?> parameters) {
        return this.query(cypher, parameters, false);
    }

    public Result query(String cypher, Map<String, ?> parameters, boolean readOnly) {
        this.validateQuery(cypher, parameters, readOnly);
        DefaultRestModelRequest request = new DefaultRestModelRequest(cypher, parameters);
        RestModelMapper mapper = new RestModelMapper(new GraphEntityMapper(this.session.metaData(), this.session.context(), this.session.getEntityInstantiator()), this.session.metaData());
        return (Result)this.session.doInTransaction(() -> {
            try (Response response = this.session.requestHandler().execute(request);){
                Iterable mappedModel = mapper.map(null, response);
                RestStatisticsModel restStatisticsModel = (RestStatisticsModel)mappedModel.iterator().next();
                if (readOnly) {
                    QueryResultModel queryResultModel = new QueryResultModel(restStatisticsModel.getResult(), null);
                    return queryResultModel;
                }
                QueryResultModel queryResultModel = new QueryResultModel(restStatisticsModel.getResult(), restStatisticsModel.getStatistics());
                return queryResultModel;
            }
        }, readOnly ? Transaction.Type.READ_ONLY : Transaction.Type.READ_WRITE);
    }

    private <T> Iterable<T> executeAndMap(Class<T> type, String cypher, Map<String, ?> parameters, ResponseMapper mapper) {
        return this.session.doInTransaction(() -> {
            if (type != null && this.session.metaData().classInfo(type.getSimpleName()) != null) {
                DefaultGraphModelRequest request = new DefaultGraphModelRequest(cypher, parameters);
                try (Response response = this.session.requestHandler().execute((GraphModelRequest)request);){
                    Iterable iterable = new GraphEntityMapper(this.session.metaData(), this.session.context(), this.session.getEntityInstantiator()).map(type, (Response<GraphModel>)response);
                    return iterable;
                }
            }
            DefaultRowModelRequest request = new DefaultRowModelRequest(cypher, parameters);
            try (Response response = this.session.requestHandler().execute((RowModelRequest)request);){
                Iterable iterable = mapper.map(type, response);
                return iterable;
            }
        }, Transaction.Type.READ_WRITE);
    }

    public long countEntitiesOfType(Class<?> entity) {
        CypherQuery countStatement;
        ClassInfo classInfo = this.session.metaData().classInfo(entity.getName());
        if (classInfo == null) {
            return 0L;
        }
        if (classInfo.isRelationshipEntity()) {
            ClassInfo startNodeInfo = null;
            ClassInfo endNodeInfo = null;
            for (FieldInfo fieldInfo : classInfo.fieldsInfo().fields()) {
                if (fieldInfo.hasAnnotation(StartNode.class)) {
                    startNodeInfo = this.session.metaData().classInfo(ClassUtils.getType(fieldInfo.getTypeDescriptor()).getName());
                } else if (fieldInfo.hasAnnotation(EndNode.class)) {
                    endNodeInfo = this.session.metaData().classInfo(ClassUtils.getType(fieldInfo.getTypeDescriptor()).getName());
                }
                if (endNodeInfo == null || startNodeInfo == null) continue;
                break;
            }
            String start = startNodeInfo.neo4jName();
            String end = endNodeInfo.neo4jName();
            String type = classInfo.neo4jName();
            countStatement = new CountStatements().countEdges(start, type, end);
        } else {
            Collection<String> labels = classInfo.staticLabels();
            if (labels.isEmpty()) {
                return 0L;
            }
            countStatement = new CountStatements().countNodes(labels);
        }
        return this.session.doInTransaction(() -> {
            try (Response response = this.session.requestHandler().execute((RowModelRequest)countStatement);){
                RowModel queryResult = (RowModel)response.next();
                Long l = queryResult == null ? 0L : ((Number)queryResult.getValues()[0]).longValue();
                return l;
            }
        }, Transaction.Type.READ_ONLY);
    }

    public long count(Class<?> clazz, Iterable<Filter> filters) {
        ClassInfo classInfo = this.session.metaData().classInfo(clazz.getSimpleName());
        if (classInfo != null) {
            this.resolvePropertyAnnotations(clazz, filters);
            CypherQuery query = classInfo.isRelationshipEntity() ? new CountStatements().countEdges(classInfo.neo4jName(), filters) : new CountStatements().countNodes(classInfo.neo4jName(), filters);
            return this.count(query, classInfo.isRelationshipEntity());
        }
        throw new RuntimeException(clazz.getName() + " is not a persistable class");
    }

    private Long count(CypherQuery query, boolean isRelationshipEntity) {
        String resultKey = isRelationshipEntity ? "COUNT(r0)" : "COUNT(n)";
        Result result = this.session.query(query.getStatement(), query.getParameters(), true);
        Map resultMap = (Map)result.iterator().next();
        return Long.parseLong(resultMap.get(resultKey).toString());
    }

    private static boolean mayBeReadWrite(String cypher) {
        Matcher matcher = WRITE_CYPHER_KEYWORDS.matcher(cypher.toUpperCase());
        return matcher.find();
    }

    private void validateQuery(String cypher, Map<String, ?> parameters, boolean readOnly) {
        if (readOnly && ExecuteQueriesDelegate.mayBeReadWrite(cypher)) {
            this.session.warn("Cypher query contains keywords that indicate a writing query but OGM is going to use a read only transaction as requested, so the query might fail.");
        }
        if (StringUtils.isEmpty((CharSequence)cypher)) {
            throw new RuntimeException("Supplied cypher statement must not be null or empty.");
        }
        if (parameters == null) {
            throw new RuntimeException("Supplied Parameters cannot be null.");
        }
    }
}

