/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.Property;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.FilterWithRelationship;
import org.neo4j.ogm.cypher.query.SortClause;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.utils.RelationshipUtils;

abstract class SessionDelegate {
    final Neo4jSession session;

    SessionDelegate(Neo4jSession session) {
        this.session = session;
    }

    SortOrder sortOrderWithResolvedProperties(Class entityType, SortOrder sortOrder) {
        return SortOrder.fromSortClauses(this.sortClausesWithResolvedProperties(entityType, sortOrder));
    }

    void resolvePropertyAnnotations(Class entityType, Iterable<Filter> filters) {
        for (Filter filter : filters) {
            if (filter.getOwnerEntityType() == null) {
                filter.setOwnerEntityType(entityType);
            }
            String propertyName = this.resolvePropertyName(filter.getOwnerEntityType(), filter.getPropertyName());
            Filter.setNameFromProperty(filter, propertyName);
            ClassInfo classInfo = this.session.metaData().classInfo(entityType.getName());
            FieldInfo fieldInfo = classInfo.fieldsInfo().get(filter.getPropertyName());
            if (fieldInfo != null) {
                filter.setPropertyConverter(fieldInfo.getPropertyConverter());
                filter.setCompositeConverter(fieldInfo.getCompositeConverter());
            }
            if (filter.isNested()) {
                this.resolveRelationshipType(filter);
                ClassInfo nestedClassInfo = this.session.metaData().classInfo(filter.getNestedPropertyType().getName());
                filter.setNestedEntityTypeLabel(this.session.metaData().entityType(nestedClassInfo.name()));
                if (!this.session.metaData().isRelationshipEntity(nestedClassInfo.name())) continue;
                filter.setNestedRelationshipEntity(true);
                continue;
            }
            if (!filter.isDeepNested()) continue;
            Class parentOwnerType = filter.getOwnerEntityType();
            for (Filter.NestedPathSegment nestedPathSegment : filter.getNestedPath()) {
                this.resolveRelationshipType(parentOwnerType, nestedPathSegment);
                ClassInfo nestedClassInfo = this.session.metaData().classInfo(nestedPathSegment.getPropertyType().getName());
                nestedPathSegment.setNestedEntityTypeLabel(this.session.metaData().entityType(nestedClassInfo.name()));
                if (this.session.metaData().isRelationshipEntity(nestedClassInfo.name())) {
                    nestedPathSegment.setNestedRelationshipEntity(true);
                }
                parentOwnerType = nestedPathSegment.getPropertyType();
            }
        }
    }

    private void resolveRelationshipType(Filter filter) {
        ClassInfo classInfo = this.session.metaData().classInfo(filter.getOwnerEntityType().getName());
        FieldInfo fieldInfo = classInfo.relationshipFieldByName(filter.getNestedPropertyName());
        String defaultRelationshipType = RelationshipUtils.inferRelationshipType(filter.getNestedPropertyName());
        this.updateRelationship(filter, fieldInfo, defaultRelationshipType);
    }

    private void resolveRelationshipType(Class parentOwnerType, Filter.NestedPathSegment segment) {
        ClassInfo classInfo = this.session.metaData().classInfo(parentOwnerType.getName());
        FieldInfo fieldInfo = classInfo.relationshipFieldByName(segment.getPropertyName());
        String defaultRelationshipType = RelationshipUtils.inferRelationshipType(segment.getPropertyName());
        this.updateRelationship(segment, fieldInfo, defaultRelationshipType);
    }

    private void updateRelationship(FilterWithRelationship filter, FieldInfo fieldInfo, String relationshipType) {
        filter.setRelationshipType(relationshipType);
        filter.setRelationshipDirection("UNDIRECTED");
        if (fieldInfo.getAnnotations() != null) {
            AnnotationInfo annotation = fieldInfo.getAnnotations().get(Relationship.class);
            if (annotation != null) {
                filter.setRelationshipType(annotation.get("type", relationshipType));
                filter.setRelationshipDirection(annotation.get("direction", "UNDIRECTED"));
            }
            if (fieldInfo.getAnnotations().get(StartNode.class) != null) {
                filter.setRelationshipDirection("OUTGOING");
            }
            if (fieldInfo.getAnnotations().get(EndNode.class) != null) {
                filter.setRelationshipDirection("INCOMING");
            }
        }
    }

    private List<SortClause> sortClausesWithResolvedProperties(Class entityType, SortOrder sortOrder) {
        ArrayList<SortClause> sortClausesWithResolvedProperties = new ArrayList<SortClause>();
        if (sortOrder != null) {
            for (SortClause sortClause : sortOrder.sortClauses()) {
                String[] properties = sortClause.getProperties();
                String[] resolvedProperties = new String[properties.length];
                for (int i = 0; i < properties.length; ++i) {
                    resolvedProperties[i] = this.escapedResolvedProperty(entityType, sortClause, i);
                }
                sortClausesWithResolvedProperties.add(sortClause.fromResolvedProperties(resolvedProperties));
            }
        }
        return sortClausesWithResolvedProperties;
    }

    private String escapedResolvedProperty(Class entityType, SortClause sortClause, int i) {
        String escapedProperty = "`%s`";
        return String.format("`%s`", this.resolvePropertyName(entityType, sortClause.getProperties()[i]));
    }

    private String resolvePropertyName(Class entityType, String propertyName) {
        AnnotationInfo annotation;
        ClassInfo classInfo = this.session.metaData().classInfo(entityType.getName());
        FieldInfo fieldInfo = classInfo.propertyFieldByName(propertyName);
        if (fieldInfo != null && fieldInfo.getAnnotations() != null && (annotation = fieldInfo.getAnnotations().get(Property.class)) != null) {
            return annotation.get("name", propertyName);
        }
        return propertyName;
    }
}

