/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;

public class MethodsInfo {
    private final Map<String, MethodInfo> methods;

    MethodsInfo() {
        this.methods = new HashMap<String, MethodInfo>();
    }

    public MethodsInfo(Class<?> cls) {
        this.methods = new HashMap<String, MethodInfo>();
        for (Method method : cls.getDeclaredMethods()) {
            Annotation[] declaredAnnotations;
            int modifiers = method.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) continue;
            ObjectAnnotations objectAnnotations = new ObjectAnnotations();
            for (Annotation annotation : declaredAnnotations = method.getDeclaredAnnotations()) {
                AnnotationInfo info = new AnnotationInfo(annotation);
                objectAnnotations.put(info.getName(), info);
            }
            this.methods.put(method.getName(), new MethodInfo(method, objectAnnotations));
        }
    }

    public MethodsInfo(Map<String, MethodInfo> methods) {
        this.methods = new HashMap<String, MethodInfo>(methods);
    }

    public Collection<MethodInfo> methods() {
        return this.methods.values();
    }

    public void append(MethodsInfo methodsInfo) {
        for (MethodInfo methodInfo : methodsInfo.methods()) {
            this.methods.putIfAbsent(methodInfo.getName(), methodInfo);
        }
    }
}

