/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.autoindex;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.autoindex.AutoIndex;
import org.neo4j.ogm.autoindex.MissingIndexException;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.DefaultRequest;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.RowDataStatement;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoIndexManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassInfo.class);
    private static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    private final List<AutoIndex> indexes;
    private Neo4jSession session;
    private final Configuration configuration;

    public AutoIndexManager(MetaData metaData, Configuration configuration, Neo4jSession session) {
        this.configuration = configuration;
        this.indexes = this.initialiseIndexMetadata(metaData);
        this.session = session;
    }

    private List<AutoIndex> initialiseIndexMetadata(MetaData metaData) {
        LOGGER.debug("Building Index Metadata.");
        ArrayList<AutoIndex> indexMetadata = new ArrayList<AutoIndex>();
        for (ClassInfo classInfo : metaData.persistentEntities()) {
            if (!classInfo.containsIndexes()) continue;
            for (FieldInfo fieldInfo : classInfo.getIndexFields()) {
                AutoIndex index = new AutoIndex(classInfo.neo4jName(), fieldInfo.property(), fieldInfo.isConstraint());
                LOGGER.debug("Adding Index [description={}]", (Object)index);
                indexMetadata.add(index);
            }
        }
        return indexMetadata;
    }

    List<AutoIndex> getIndexes() {
        return this.indexes;
    }

    public void build() {
        switch (this.configuration.getAutoIndex()) {
            case ASSERT: {
                this.assertIndexes();
                break;
            }
            case VALIDATE: {
                this.validateIndexes();
                break;
            }
            case DUMP: {
                this.dumpIndexes();
            }
        }
    }

    private void dumpIndexes() {
        String newLine = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        for (AutoIndex index : this.indexes) {
            sb.append(index.getCreateStatement().getStatement()).append(newLine);
        }
        File file = new File(this.configuration.getDumpDir(), this.configuration.getDumpFilename());
        FileWriter writer = null;
        LOGGER.debug("Dumping Indexes to: [{}]", (Object)file.toString());
        try {
            writer = new FileWriter(file);
            writer.write(sb.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write file to " + file.getAbsolutePath(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void validateIndexes() {
        LOGGER.debug("Validating Indexes");
        org.neo4j.ogm.session.request.DefaultRequest indexRequests = this.buildProcedures();
        ArrayList<AutoIndex> copyOfIndexes = new ArrayList<AutoIndex>(this.indexes);
        Transaction tx = this.session.beginTransaction();
        Object object = null;
        try {
            try (Response response = this.session.requestHandler().execute((DefaultRequest)indexRequests);){
                RowModel rowModel;
                while ((rowModel = (RowModel)response.next()) != null) {
                    if (rowModel.getValues().length == 3 && rowModel.getValues()[2].equals("node_unique_property")) continue;
                    for (AutoIndex index : this.indexes) {
                        String description = index.getDescription();
                        if (!(description = description.replace("`", "")).replaceAll("\\s+", "").equalsIgnoreCase(((String)rowModel.getValues()[0]).replaceAll("\\s+", ""))) continue;
                        copyOfIndexes.remove(index);
                    }
                }
            }
            tx.commit();
        }
        catch (Throwable response) {
            object = response;
            throw response;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable response) {
                        ((Throwable)object).addSuppressed(response);
                    }
                } else {
                    tx.close();
                }
            }
        }
        if (!copyOfIndexes.isEmpty()) {
            String missingIndexes = "[";
            for (AutoIndex s : copyOfIndexes) {
                missingIndexes = missingIndexes + s.getDescription() + ", ";
            }
            missingIndexes = missingIndexes + "]";
            throw new MissingIndexException("Validation of Constraints and Indexes failed. Could not find the following : " + missingIndexes);
        }
    }

    private void assertIndexes() {
        LOGGER.debug("Asserting Indexes.");
        org.neo4j.ogm.session.request.DefaultRequest indexRequests = this.buildProcedures();
        ArrayList<Statement> dropStatements = new ArrayList<Statement>();
        try (Transaction tx = this.session.beginTransaction();){
            try (Response response = this.session.requestHandler().execute((DefaultRequest)indexRequests);){
                RowModel rowModel;
                while ((rowModel = (RowModel)response.next()) != null) {
                    if (rowModel.getValues().length == 3 && rowModel.getValues()[2].equals("node_unique_property") || rowModel.getValues().length == 6 && rowModel.getValues()[4].equals("node_unique_property")) continue;
                    String statement = (String)rowModel.getValues()[0];
                    if (statement.startsWith("CONSTRAINT")) {
                        statement = this.escapeConstraintStatement(statement);
                    } else if (statement.startsWith("INDEX")) {
                        statement = this.escapeIndexStatement(statement);
                    }
                    String dropStatement = "DROP " + statement;
                    LOGGER.debug("[{}] added to drop statements.", (Object)dropStatement);
                    dropStatements.add(new RowDataStatement(dropStatement, EMPTY_MAP));
                }
            }
            tx.commit();
        }
        org.neo4j.ogm.session.request.DefaultRequest dropIndexesRequest = new org.neo4j.ogm.session.request.DefaultRequest();
        dropIndexesRequest.setStatements(dropStatements);
        LOGGER.debug("Dropping all indexes and constraints");
        try (Transaction tx = this.session.beginTransaction();){
            this.session.requestHandler().execute((DefaultRequest)dropIndexesRequest);
            tx.commit();
        }
        this.create();
    }

    private org.neo4j.ogm.session.request.DefaultRequest buildProcedures() {
        ArrayList<Statement> procedures = new ArrayList<Statement>();
        procedures.add(new RowDataStatement("CALL db.constraints()", EMPTY_MAP));
        procedures.add(new RowDataStatement("CALL db.indexes()", EMPTY_MAP));
        org.neo4j.ogm.session.request.DefaultRequest getIndexesRequest = new org.neo4j.ogm.session.request.DefaultRequest();
        getIndexesRequest.setStatements(procedures);
        return getIndexesRequest;
    }

    private void create() {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (AutoIndex index : this.indexes) {
            Statement createStatement = index.getCreateStatement();
            LOGGER.debug("[{}] added to create statements.", (Object)createStatement);
            statements.add(createStatement);
        }
        org.neo4j.ogm.session.request.DefaultRequest request = new org.neo4j.ogm.session.request.DefaultRequest();
        request.setStatements(statements);
        LOGGER.debug("Creating indexes and constraints.");
        try (Transaction tx = this.session.beginTransaction();){
            Response response = this.session.requestHandler().execute((DefaultRequest)request);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
            tx.commit();
        }
    }

    private String escapeConstraintStatement(String statement) {
        int startIndex = statement.indexOf("CONSTRAINT ON (");
        if (startIndex != -1) {
            StringBuilder str = new StringBuilder(statement);
            str = str.insert(startIndex += 16, "`");
            startIndex = str.indexOf(":", startIndex);
            str = str.insert(startIndex, "`");
            str = str.insert(startIndex += 2, "`");
            startIndex = str.indexOf(" ", startIndex);
            str = str.insert(startIndex, "`");
            startIndex = str.indexOf("ASSERT ", startIndex);
            str = str.insert(startIndex += 7, "`");
            startIndex = str.indexOf(".", startIndex);
            str = str.insert(startIndex, "`");
            str = str.insert(startIndex += 2, "`");
            startIndex = str.indexOf(" ", startIndex);
            str = str.insert(startIndex, "`");
            statement = str.toString();
        }
        return statement;
    }

    private String escapeIndexStatement(String statement) {
        int startIndex = statement.indexOf("INDEX ON :");
        if (startIndex != -1) {
            StringBuilder str = new StringBuilder(statement);
            str = str.insert(startIndex += 10, "`");
            startIndex = str.indexOf("(", startIndex);
            str = str.insert(startIndex, "`");
            str = str.insert(startIndex += 2, "`");
            startIndex = str.indexOf(")", startIndex);
            str = str.insert(startIndex, "`");
            statement = str.toString();
        }
        return statement;
    }
}

