/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.exception.core.BaseClassNotFoundException;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.Node;

public class EntityFactory {
    private final Map<String, String> taxaLeafClass = new HashMap<String, String>();
    private final MetaData metadata;

    public EntityFactory(MetaData metadata) {
        this.metadata = metadata;
    }

    public <T> T newObject(Node nodeModel) {
        return this.instantiateObjectFromTaxa(nodeModel.getLabels());
    }

    public <T> T newObject(Edge edgeModel) {
        return this.instantiateObjectFromTaxa(edgeModel.getType());
    }

    public <T> T newObject(ClassInfo classInfo) {
        return (T)EntityFactory.instantiate(classInfo.getUnderlyingClass());
    }

    public <T> T newObject(Class<T> clarse) {
        return EntityFactory.instantiate(clarse);
    }

    private <T> T instantiateObjectFromTaxa(String ... taxa) {
        if (taxa == null || taxa.length == 0) {
            throw new BaseClassNotFoundException("<null>");
        }
        String fqn = this.resolve(taxa);
        Class<?> loadedClass = this.metadata.classInfo(fqn).getUnderlyingClass();
        return (T)EntityFactory.instantiate(loadedClass);
    }

    private String resolve(String ... taxa) {
        String fqn = this.taxaLeafClass.get(Arrays.toString(taxa));
        if (fqn == null) {
            ClassInfo classInfo = this.metadata.resolve(taxa);
            if (classInfo != null) {
                fqn = classInfo.name();
                this.taxaLeafClass.put(Arrays.toString(taxa), fqn);
            } else {
                throw new BaseClassNotFoundException(Arrays.toString(taxa));
            }
        }
        return fqn;
    }

    private static <T> T instantiate(Class<T> loadedClass) {
        try {
            Constructor<T> defaultConstructor = loadedClass.getDeclaredConstructor(new Class[0]);
            defaultConstructor.setAccessible(true);
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new MappingException("Unable to instantiate " + loadedClass, e);
        }
    }
}

