/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler.builders.statement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.neo4j.ogm.cypher.compiler.CypherStatementBuilder;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;

public class ExistingRelationshipStatementBuilder
implements CypherStatementBuilder {
    private final StatementFactory statementFactory;
    private final Set<Edge> edges;

    public ExistingRelationshipStatementBuilder(Set<Edge> edges, StatementFactory statementFactory) {
        this.edges = edges;
        this.statementFactory = statementFactory;
    }

    @Override
    public Statement build() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder queryBuilder = new StringBuilder();
        if (this.edges.size() > 0) {
            queryBuilder.append("UNWIND {rows} AS row MATCH ()-[r]-() WHERE ID(r) = row.relId SET r += row.props ");
            queryBuilder.append("RETURN ID(r) as ref, ID(r) as id, {type} as type");
            ArrayList rows = new ArrayList();
            for (Edge edge : this.edges) {
                HashMap<String, Serializable> rowMap = new HashMap<String, Serializable>();
                rowMap.put("relId", edge.getId());
                HashMap<String, Object> props = new HashMap<String, Object>();
                for (Property property : edge.getPropertyList()) {
                    props.put((String)property.getKey(), property.getValue());
                }
                rowMap.put("props", props);
                rows.add(rowMap);
            }
            parameters.put("rows", rows);
            parameters.put("type", "rel");
        }
        return this.statementFactory.statement(queryBuilder.toString(), parameters);
    }
}

