/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher;

import java.util.EnumSet;
import java.util.Map;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.NoOpPropertyValueTransformer;
import org.neo4j.ogm.cypher.function.DistanceComparison;
import org.neo4j.ogm.cypher.function.FilterFunction;
import org.neo4j.ogm.cypher.function.PropertyComparison;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;

public class Filter {
    private int index = 0;
    private String propertyName;
    private ComparisonOperator comparisonOperator;
    private BooleanOperator booleanOperator = BooleanOperator.NONE;
    private boolean negated;
    private Class<?> ownerEntityType;
    private String nestedEntityTypeLabel;
    private String nestedPropertyName;
    private Class<?> nestedPropertyType;
    private String relationshipType;
    private String relationshipDirection;
    private AttributeConverter propertyConverter;
    private CompositeAttributeConverter compositeAttributeConverter;
    private boolean nestedRelationshipEntity;
    private FilterFunction function;

    public Filter(FilterFunction function) {
        this.function = function;
        this.function.setFilter(this);
    }

    public Filter(DistanceComparison distanceComparisonFunction, ComparisonOperator comparisonOperator) {
        this.function = distanceComparisonFunction;
        this.function.setFilter(this);
        this.comparisonOperator = comparisonOperator;
    }

    public Filter(String propertyName, ComparisonOperator comparisonOperator, Object propertyValue) {
        this(new PropertyComparison(propertyValue));
        this.comparisonOperator = comparisonOperator;
        this.propertyName = propertyName;
    }

    public Filter(String propertyName, FilterFunction filterFunction) {
        this(filterFunction);
        this.propertyName = propertyName;
    }

    public Filter(String propertyName, ComparisonOperator comparisonOperator) {
        this(new PropertyComparison(null));
        this.propertyName = propertyName;
        if (!EnumSet.of(ComparisonOperator.EXISTS, ComparisonOperator.IS_TRUE, ComparisonOperator.IS_NULL).contains((Object)comparisonOperator)) {
            throw new RuntimeException("This constructor can only be used with Unary comparison operators");
        }
        this.comparisonOperator = comparisonOperator;
    }

    public String getRelationshipDirection() {
        return this.relationshipDirection;
    }

    public void setRelationshipDirection(String relationshipDirection) {
        this.relationshipDirection = relationshipDirection;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Deprecated
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public ComparisonOperator getComparisonOperator() {
        return this.comparisonOperator;
    }

    public BooleanOperator getBooleanOperator() {
        return this.booleanOperator;
    }

    public void setBooleanOperator(BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public Class<?> getOwnerEntityType() {
        return this.ownerEntityType;
    }

    public void setOwnerEntityType(Class<?> ownerEntityType) {
        this.ownerEntityType = ownerEntityType;
    }

    public String getNestedPropertyName() {
        return this.nestedPropertyName;
    }

    public void setNestedPropertyName(String nestedPropertyName) {
        this.nestedPropertyName = nestedPropertyName;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public boolean isNested() {
        return this.nestedPropertyName != null;
    }

    public Class<?> getNestedPropertyType() {
        return this.nestedPropertyType;
    }

    public void setNestedPropertyType(Class<?> nestedPropertyType) {
        this.nestedPropertyType = nestedPropertyType;
    }

    public String getNestedEntityTypeLabel() {
        return this.nestedEntityTypeLabel;
    }

    public void setNestedEntityTypeLabel(String nestedEntityTypeLabel) {
        this.nestedEntityTypeLabel = nestedEntityTypeLabel;
    }

    public boolean isNestedRelationshipEntity() {
        return this.nestedRelationshipEntity;
    }

    public void setNestedRelationshipEntity(boolean nestedRelationshipEntity) {
        this.nestedRelationshipEntity = nestedRelationshipEntity;
    }

    public String uniqueParameterName() {
        return this.isNested() ? this.getNestedPropertyName() + "_" + this.getPropertyName() + "_" + this.index : this.getPropertyName() + "_" + this.index;
    }

    public AttributeConverter getPropertyConverter() {
        return this.propertyConverter;
    }

    public void setPropertyConverter(AttributeConverter propertyConverter) {
        this.propertyConverter = propertyConverter;
    }

    public CompositeAttributeConverter getCompositeAttributeConverter() {
        return this.compositeAttributeConverter;
    }

    public void setCompositeConverter(CompositeAttributeConverter compositeAttributeConverter) {
        this.compositeAttributeConverter = compositeAttributeConverter;
    }

    public Object getTransformedPropertyValue() {
        Object value = this.function.getValue();
        if (this.getPropertyConverter() != null) {
            value = this.getPropertyConverter().toGraphProperty(value);
        } else if (this.getCompositeAttributeConverter() != null) {
            throw new MappingException("Properties with a CompositeAttributeConverter are not supported by Filters in this version of OGM. Consider implementing a custom FilterFunction.");
        }
        return this.transformPropertyValue(value);
    }

    private Object transformPropertyValue(Object value) {
        if (this.comparisonOperator != null) {
            return this.comparisonOperator.getPropertyValueTransformer().transformPropertyValue(value);
        }
        return new NoOpPropertyValueTransformer().transformPropertyValue(value);
    }

    public FilterFunction getFunction() {
        return this.function;
    }

    public void setFunction(FilterFunction function) {
        assert (function != null);
        this.function = function;
        this.function.setFilter(this);
    }

    void setIndex(int index) {
        this.index = index;
    }

    public String toCypher(String nodeIdentifier, boolean addWhereClause) {
        String fragment = this.function.expression(nodeIdentifier);
        String suffix = this.isNegated() ? this.negate(fragment) : fragment;
        return this.cypherPrefix(addWhereClause) + suffix;
    }

    public Map<String, Object> parameters() {
        return this.function.parameters();
    }

    private String cypherPrefix(boolean addWhereClause) {
        StringBuilder cypher = new StringBuilder();
        if (addWhereClause) {
            cypher.append("WHERE ");
        } else if (!this.getBooleanOperator().equals((Object)BooleanOperator.NONE)) {
            cypher.append(this.getBooleanOperator().getValue()).append(" ");
        }
        return cypher.toString();
    }

    private String negate(String expression) {
        return String.format("NOT(%s) ", expression);
    }

    public static void setNameFromProperty(Filter filter, String propertyName) {
        filter.propertyName = propertyName;
    }
}

