/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.io.Serializable;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.cypher.query.DefaultGraphModelRequest;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadOneDelegate {
    private static final Logger logger = LoggerFactory.getLogger(LoadOneDelegate.class);
    private Neo4jSession session;

    public LoadOneDelegate(Neo4jSession session) {
        this.session = session;
    }

    public <T, ID extends Serializable> T load(Class<T> type, ID id) {
        return this.load(type, id, 1);
    }

    public <T, ID extends Serializable> T load(Class<T> type, ID id, int depth) {
        ClassInfo classInfo = this.session.metaData().classInfo(type.getName());
        if (classInfo == null) {
            throw new IllegalArgumentException(type + " is not a managed entity.");
        }
        FieldInfo primaryIndexField = classInfo.primaryIndexField();
        if (primaryIndexField != null && !primaryIndexField.isTypeOf(id.getClass())) {
            throw new IllegalArgumentException("Supplied id does not match primary index type on supplied class " + type.getName());
        }
        if (primaryIndexField == null && !(id instanceof Long)) {
            throw new IllegalArgumentException("Supplied id must be of type Long (native graph id) when supplied class does not have primary id" + type.getName());
        }
        QueryStatements<ID> queryStatements = this.session.queryStatementsFor(type, depth);
        String entityType = this.session.entityType(type.getName());
        if (entityType == null) {
            logger.warn("Unable to find database label for entity " + type.getName() + " : no results will be returned. Make sure the class is registered, and not abstract without @NodeEntity annotation");
        }
        PagingAndSortingQuery qry = queryStatements.findOneByType(entityType, id, depth);
        DefaultGraphModelRequest request = new DefaultGraphModelRequest(qry.getStatement(), qry.getParameters());
        try (Response response = this.session.requestHandler().execute((GraphModelRequest)request);){
            new GraphEntityMapper(this.session.metaData(), this.session.context()).map(type, (Response<GraphModel>)response);
            T t = this.lookup(type, id);
            return t;
        }
    }

    private <T, U> T lookup(Class<T> type, U id) {
        ClassInfo typeInfo = this.session.metaData().classInfo(type.getName());
        FieldInfo primaryIndex = typeInfo.primaryIndexField();
        Object ref = typeInfo.annotationsInfo().get(RelationshipEntity.class) == null ? (primaryIndex == null ? this.session.context().getNodeEntity((Long)id) : this.session.context().getNodeEntityById(typeInfo, id)) : (primaryIndex == null ? this.session.context().getRelationshipEntity((Long)id) : this.session.context().getRelationshipEntityById(typeInfo, id));
        try {
            return type.cast(ref);
        }
        catch (ClassCastException cce) {
            logger.warn("Could not cast entity {} for id {} to {}", new Object[]{ref, id, type});
            return null;
        }
    }
}

