/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotation.Labels;
import org.neo4j.ogm.annotation.Properties;
import org.neo4j.ogm.annotation.Property;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;
import org.neo4j.ogm.typeconversion.MapCompositeConverter;
import org.neo4j.ogm.utils.ClassUtils;
import org.neo4j.ogm.utils.RelationshipUtils;

public class FieldInfo {
    private static final String PRIMITIVES = "char,byte,short,int,long,float,double,boolean,char[],byte[],short[],int[],long[],float[],double[],boolean[]";
    private static final String AUTOBOXERS = "java.lang.Objectjava.lang.Characterjava.lang.Bytejava.lang.Shortjava.lang.Integerjava.lang.Longjava.lang.Floatjava.lang.Doublejava.lang.Booleanjava.lang.Stringjava.lang.Object[]java.lang.Character[]java.lang.Byte[]java.lang.Short[]java.lang.Integer[]java.lang.Long[]java.lang.Float[]java.lang.Double[]java.lang.Boolean[]java.lang.String[]";
    private final String name;
    private final String descriptor;
    private final String typeParameterDescriptor;
    private final ObjectAnnotations annotations;
    private final boolean isArray;
    private final ClassInfo containingClassInfo;
    private final Field field;
    private final Class<?> fieldType;
    private AttributeConverter<?, ?> propertyConverter;
    private CompositeAttributeConverter<?> compositeConverter;

    public FieldInfo(ClassInfo classInfo, Field field, String typeParameterDescriptor, ObjectAnnotations annotations) {
        this.containingClassInfo = classInfo;
        this.field = field;
        this.fieldType = field.getType();
        field.getModifiers();
        this.isArray = field.getType().isArray();
        this.name = field.getName();
        this.descriptor = field.getType().getTypeName();
        this.typeParameterDescriptor = typeParameterDescriptor;
        this.annotations = annotations;
        if (!this.annotations.isEmpty()) {
            Object converter = this.getAnnotations().getConverter(this.fieldType);
            if (converter instanceof AttributeConverter) {
                this.setPropertyConverter((AttributeConverter)converter);
            } else if (converter instanceof CompositeAttributeConverter) {
                this.setCompositeConverter((CompositeAttributeConverter)converter);
            } else {
                if (converter != null) {
                    throw new IllegalStateException(String.format("The converter for field %s is neither an instance of AttributeConverter or CompositeAttributeConverter", this.name));
                }
                AnnotationInfo properties = this.getAnnotations().get(Properties.class);
                if (properties != null) {
                    if (this.fieldType.equals(Map.class)) {
                        Type fieldGenericType = field.getGenericType();
                        MapCompositeConverter mapCompositeConverter = new MapCompositeConverter(properties.get("prefix", field.getName()), properties.get("delimiter"), Boolean.valueOf(properties.get("allowCast")), (ParameterizedType)fieldGenericType);
                        this.setCompositeConverter(mapCompositeConverter);
                    } else {
                        throw new MappingException("@Properties annotation is allowed only on fields of type java.util.Map");
                    }
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String property() {
        if (this.persistableAsProperty()) {
            AnnotationInfo propertyAnnotation;
            if (this.annotations != null && (propertyAnnotation = this.annotations.get(Property.class)) != null) {
                return propertyAnnotation.get("name", this.getName());
            }
            return this.getName();
        }
        return null;
    }

    public String relationship() {
        if (!this.persistableAsProperty()) {
            AnnotationInfo relationshipAnnotation;
            if (this.annotations != null && (relationshipAnnotation = this.annotations.get(Relationship.class)) != null) {
                return relationshipAnnotation.get("type", RelationshipUtils.inferRelationshipType(this.getName()));
            }
            return RelationshipUtils.inferRelationshipType(this.getName());
        }
        return null;
    }

    public String relationshipTypeAnnotation() {
        AnnotationInfo relationshipAnnotation;
        if (!this.persistableAsProperty() && this.annotations != null && (relationshipAnnotation = this.annotations.get(Relationship.class)) != null) {
            return relationshipAnnotation.get("type", null);
        }
        return null;
    }

    public ObjectAnnotations getAnnotations() {
        return this.annotations;
    }

    public boolean persistableAsProperty() {
        return PRIMITIVES.contains(this.descriptor) || AUTOBOXERS.contains(this.descriptor) && this.typeParameterDescriptor == null || this.typeParameterDescriptor != null && AUTOBOXERS.contains(this.typeParameterDescriptor) || this.propertyConverter != null || this.compositeConverter != null;
    }

    public AttributeConverter getPropertyConverter() {
        return this.propertyConverter;
    }

    void setPropertyConverter(AttributeConverter<?, ?> propertyConverter) {
        if (this.propertyConverter == null && this.compositeConverter == null && propertyConverter != null) {
            this.propertyConverter = propertyConverter;
        }
    }

    public boolean hasPropertyConverter() {
        return this.propertyConverter != null;
    }

    public CompositeAttributeConverter getCompositeConverter() {
        return this.compositeConverter;
    }

    public void setCompositeConverter(CompositeAttributeConverter<?> converter) {
        if (this.propertyConverter == null && this.compositeConverter == null && converter != null) {
            this.compositeConverter = converter;
        }
    }

    public boolean hasCompositeConverter() {
        return this.compositeConverter != null;
    }

    public String relationshipDirection(String defaultDirection) {
        if (this.relationship() != null) {
            AnnotationInfo annotationInfo = this.getAnnotations().get(Relationship.class);
            if (annotationInfo == null) {
                return defaultDirection;
            }
            return annotationInfo.get("direction", defaultDirection);
        }
        throw new RuntimeException("relationship direction call invalid");
    }

    public boolean isTypeOf(Class<?> type) {
        while (type != null) {
            String typeSignature = type.getName();
            if (this.descriptor != null && this.descriptor.equals(typeSignature)) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = iface.getName();
                if (this.descriptor == null || !this.descriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean isIterable() {
        return Iterable.class.isAssignableFrom(this.fieldType);
    }

    public boolean isParameterisedTypeOf(Class<?> type) {
        while (type != null) {
            String typeSignature = type.getName();
            if (this.typeParameterDescriptor != null && this.typeParameterDescriptor.equals(typeSignature)) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = iface.getName();
                if (this.typeParameterDescriptor == null || !this.typeParameterDescriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean isArrayOf(Class<?> type) {
        while (type != null) {
            String typeSignature = type.getName();
            if (this.descriptor != null && this.descriptor.equals(typeSignature + "[]")) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = iface.getName();
                if (this.descriptor == null || !this.descriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public String getCollectionClassname() {
        return this.descriptor;
    }

    public boolean isScalar() {
        return !this.isIterable() && !this.isArray();
    }

    public boolean isLabelField() {
        return this.getAnnotations().get(Labels.class) != null;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotations().get(annotationName) != null;
    }

    public boolean hasAnnotation(Class<?> annotationNameClass) {
        return this.getAnnotations().get(annotationNameClass.getName()) != null;
    }

    public String getTypeDescriptor() {
        if (!this.isIterable() || this.isArray()) {
            return this.descriptor;
        }
        return this.typeParameterDescriptor;
    }

    public Class<?> convertedType() {
        if (this.hasPropertyConverter() || this.hasCompositeConverter()) {
            Class<?> converterClass = this.hasPropertyConverter() ? this.getPropertyConverter().getClass() : this.getCompositeConverter().getClass();
            String methodName = this.hasPropertyConverter() ? "toGraphProperty" : "toGraphProperties";
            try {
                for (Method method : converterClass.getDeclaredMethods()) {
                    if (!method.getName().equals(methodName) || method.isSynthetic()) continue;
                    return method.getReturnType();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public boolean isConstraint() {
        AnnotationInfo idAnnotation = this.getAnnotations().get(Id.class.getName());
        if (idAnnotation != null) {
            return true;
        }
        AnnotationInfo indexAnnotation = this.getAnnotations().get(Index.class.getName());
        return indexAnnotation != null && indexAnnotation.get("unique", "false").equals("true");
    }

    public static void write(Field field, Object instance, Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object read(Field field, Object instance) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(Object instance, Object value) {
        if (this.hasPropertyConverter()) {
            value = this.getPropertyConverter().toEntityAttribute(value);
            FieldInfo.write(this.field, instance, value);
        } else {
            if (this.isScalar()) {
                String descriptor = this.getTypeDescriptor();
                value = Utils.coerceTypes(ClassUtils.getType(descriptor), value);
            }
            FieldInfo.write(this.field, instance, value);
        }
    }

    public void writeDirect(Object instance, Object value) {
        FieldInfo.write(this.field, instance, value);
    }

    public Class<?> type() {
        Class<?> convertedType = this.convertedType();
        if (convertedType != null) {
            return convertedType;
        }
        return this.fieldType;
    }

    public String relationshipName() {
        return this.relationship();
    }

    public boolean forScalar() {
        return !Iterable.class.isAssignableFrom(this.type()) && !this.type().isArray();
    }

    public String typeParameterDescriptor() {
        return this.getTypeDescriptor();
    }

    public Object read(Object instance) {
        return FieldInfo.read(this.containingClassInfo.getField(this), instance);
    }

    public Object readProperty(Object instance) {
        if (this.hasCompositeConverter()) {
            throw new IllegalStateException("The readComposite method should be used for fields with a CompositeAttributeConverter");
        }
        Object value = FieldInfo.read(this.containingClassInfo.getField(this), instance);
        if (this.hasPropertyConverter()) {
            value = this.getPropertyConverter().toGraphProperty(value);
        }
        return value;
    }

    public Map<String, ?> readComposite(Object instance) {
        if (!this.hasCompositeConverter()) {
            throw new IllegalStateException("readComposite should only be used when a field is annotated with a CompositeAttributeConverter");
        }
        Object value = FieldInfo.read(this.containingClassInfo.getField(this), instance);
        return this.getCompositeConverter().toGraphProperties(value);
    }

    public String relationshipType() {
        return this.relationship();
    }

    public String propertyName() {
        return this.property();
    }

    public boolean isComposite() {
        return this.hasCompositeConverter();
    }

    public String relationshipDirection() {
        AnnotationInfo relationshipAnnotation;
        ObjectAnnotations annotations = this.getAnnotations();
        if (annotations != null && (relationshipAnnotation = annotations.get(Relationship.class)) != null) {
            return relationshipAnnotation.get("direction", "UNDIRECTED");
        }
        return "UNDIRECTED";
    }

    public String typeDescriptor() {
        return this.getTypeDescriptor();
    }

    public Field getField() {
        return this.field;
    }

    public ClassInfo containingClassInfo() {
        return this.containingClassInfo;
    }
}

