/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.GraphId;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.PostLoad;
import org.neo4j.ogm.annotation.Property;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.annotation.Transient;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.exception.core.MetadataException;
import org.neo4j.ogm.id.IdStrategy;
import org.neo4j.ogm.id.InternalIdStrategy;
import org.neo4j.ogm.id.UuidStrategy;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.AnnotationsInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.FieldsInfo;
import org.neo4j.ogm.metadata.InterfacesInfo;
import org.neo4j.ogm.metadata.LazyInstance;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.metadata.MethodsInfo;
import org.neo4j.ogm.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassInfo.class);
    private final List<ClassInfo> directSubclasses = new ArrayList<ClassInfo>();
    private final List<ClassInfo> directInterfaces = new ArrayList<ClassInfo>();
    private final List<ClassInfo> directImplementingClasses = new ArrayList<ClassInfo>();
    private String className;
    private String directSuperclassName;
    private String neo4jName;
    private boolean isInterface;
    private boolean isAbstract;
    private boolean isEnum;
    private boolean hydrated;
    private FieldsInfo fieldsInfo;
    private MethodsInfo methodsInfo;
    private AnnotationsInfo annotationsInfo;
    private InterfacesInfo interfacesInfo;
    private ClassInfo directSuperclass;
    private Map<Class, List<FieldInfo>> iterableFieldsForType = new HashMap<Class, List<FieldInfo>>();
    private Map<FieldInfo, Field> fieldInfoFields = new ConcurrentHashMap<FieldInfo, Field>();
    private volatile Set<FieldInfo> fieldInfos;
    private volatile Map<String, FieldInfo> propertyFields;
    private volatile Map<String, FieldInfo> indexFields;
    private volatile LazyInstance<FieldInfo> identityField;
    private volatile FieldInfo primaryIndexField = null;
    private volatile FieldInfo labelField = null;
    private volatile boolean labelFieldMapped = false;
    private volatile boolean isPostLoadMethodMapped = false;
    private volatile MethodInfo postLoadMethod;
    private boolean primaryIndexFieldChecked = false;
    private Class<?> cls;
    private Class<? extends IdStrategy> idStrategyClass;
    private IdStrategy idStrategy;

    ClassInfo(String name, ClassInfo subclass) {
        this.className = name;
        this.hydrated = false;
        this.fieldsInfo = new FieldsInfo();
        this.methodsInfo = new MethodsInfo();
        this.annotationsInfo = new AnnotationsInfo();
        this.interfacesInfo = new InterfacesInfo();
        this.addSubclass(subclass);
    }

    public ClassInfo(Class<?> cls) {
        this.cls = cls;
        int modifiers = cls.getModifiers();
        this.isInterface = Modifier.isInterface(modifiers);
        this.isAbstract = Modifier.isAbstract(modifiers);
        this.isEnum = cls.isEnum();
        this.className = cls.getName();
        if (cls.getSuperclass() != null) {
            this.directSuperclassName = cls.getSuperclass().getName();
        }
        this.interfacesInfo = new InterfacesInfo(cls);
        this.fieldsInfo = new FieldsInfo(this, cls);
        this.methodsInfo = new MethodsInfo(cls);
        this.annotationsInfo = new AnnotationsInfo(cls);
        if (this.isRelationshipEntity() && this.labelFieldOrNull() != null) {
            throw new MappingException(String.format("'%s' is a relationship entity. The @Labels annotation can't be applied to relationship entities.", this.name()));
        }
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (!fieldInfo.hasAnnotation(Property.class) || !fieldInfo.hasCompositeConverter()) continue;
            throw new MappingException(String.format("'%s' has both @Convert and @Property annotations applied to the field '%s'", this.name(), fieldInfo.getName()));
        }
    }

    void hydrate(ClassInfo classInfoDetails) {
        if (!this.hydrated) {
            this.hydrated = true;
            this.isAbstract = classInfoDetails.isAbstract;
            this.isInterface = classInfoDetails.isInterface;
            this.isEnum = classInfoDetails.isEnum;
            this.directSuperclassName = classInfoDetails.directSuperclassName;
            this.cls = classInfoDetails.cls;
            this.interfacesInfo.append(classInfoDetails.interfacesInfo());
            this.annotationsInfo.append(classInfoDetails.annotationsInfo());
            this.fieldsInfo.append(classInfoDetails.fieldsInfo());
            this.methodsInfo.append(classInfoDetails.methodsInfo());
        }
    }

    void extend(ClassInfo classInfo) {
        this.interfacesInfo.append(classInfo.interfacesInfo());
        this.fieldsInfo.append(classInfo.fieldsInfo());
        this.methodsInfo.append(classInfo.methodsInfo());
    }

    void addSubclass(ClassInfo subclass) {
        if (subclass.directSuperclass != null && subclass.directSuperclass != this) {
            throw new RuntimeException(subclass.className + " has two superclasses: " + subclass.directSuperclass.className + ", " + this.className);
        }
        subclass.directSuperclass = this;
        this.directSubclasses.add(subclass);
    }

    boolean hydrated() {
        return this.hydrated;
    }

    public String name() {
        return this.className;
    }

    String simpleName() {
        return this.className.substring(this.className.lastIndexOf(46) + 1);
    }

    public ClassInfo directSuperclass() {
        return this.directSuperclass;
    }

    public Collection<String> staticLabels() {
        return this.collectLabels(new ArrayList<String>());
    }

    public String neo4jName() {
        if (this.neo4jName == null) {
            AnnotationInfo annotationInfo = this.annotationsInfo.get(NodeEntity.class);
            if (annotationInfo != null) {
                this.neo4jName = annotationInfo.get("label", this.simpleName());
                return this.neo4jName;
            }
            annotationInfo = this.annotationsInfo.get(RelationshipEntity.class);
            if (annotationInfo != null) {
                this.neo4jName = annotationInfo.get("type", this.simpleName().toUpperCase());
                return this.neo4jName;
            }
            if (!this.isAbstract) {
                this.neo4jName = this.simpleName();
            }
        }
        return this.neo4jName;
    }

    private Collection<String> collectLabels(Collection<String> labelNames) {
        if (!this.isAbstract || this.annotationsInfo.get(NodeEntity.class) != null) {
            labelNames.add(this.neo4jName());
        }
        if (this.directSuperclass != null && !"java.lang.Object".equals(this.directSuperclass.className)) {
            this.directSuperclass.collectLabels(labelNames);
        }
        for (ClassInfo interfaceInfo : this.directInterfaces()) {
            interfaceInfo.collectLabels(labelNames);
        }
        return labelNames;
    }

    List<ClassInfo> directSubclasses() {
        return this.directSubclasses;
    }

    List<ClassInfo> directImplementingClasses() {
        return this.directImplementingClasses;
    }

    List<ClassInfo> directInterfaces() {
        return this.directInterfaces;
    }

    InterfacesInfo interfacesInfo() {
        return this.interfacesInfo;
    }

    public Collection<AnnotationInfo> annotations() {
        return this.annotationsInfo.list();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public AnnotationsInfo annotationsInfo() {
        return this.annotationsInfo;
    }

    String superclassName() {
        return this.directSuperclassName;
    }

    public FieldsInfo fieldsInfo() {
        return this.fieldsInfo;
    }

    MethodsInfo methodsInfo() {
        return this.methodsInfo;
    }

    public FieldInfo identityFieldOrNull() {
        this.initIdentityField();
        return this.identityField.get();
    }

    public FieldInfo identityField() {
        this.initIdentityField();
        FieldInfo field = this.identityField.get();
        if (field == null) {
            throw new MetadataException("No internal identity field found for class: " + this.className);
        }
        return field;
    }

    private void initIdentityField() {
        if (this.identityField == null) {
            this.identityField = new LazyInstance<FieldInfo>(() -> {
                Collection<FieldInfo> identityFields = this.getFieldInfos(this::isInternalIdentity);
                if (identityFields.size() == 1) {
                    return identityFields.iterator().next();
                }
                if (identityFields.size() > 1) {
                    throw new MetadataException("Expected exactly one internal identity field (@GraphId or @Id with InternalIdStrategy), found " + identityFields.size() + " " + identityFields);
                }
                FieldInfo fieldInfo = this.fieldsInfo().get("id");
                if (fieldInfo != null && fieldInfo.getTypeDescriptor().equals("java.lang.Long")) {
                    return fieldInfo;
                }
                return null;
            });
        }
    }

    public boolean hasIdentityField() {
        this.initIdentityField();
        return this.identityField.exists();
    }

    private boolean isInternalIdentity(FieldInfo fieldInfo) {
        return fieldInfo.getAnnotations().has(GraphId.class) || fieldInfo.getAnnotations().has(Id.class) && fieldInfo.getAnnotations().has(GeneratedValue.class) && ((GeneratedValue)fieldInfo.getAnnotations().get(GeneratedValue.class).getAnnotation()).strategy().equals(InternalIdStrategy.class);
    }

    Collection<FieldInfo> getFieldInfos(Predicate<FieldInfo> predicate) {
        return this.fieldsInfo().fields().stream().filter(predicate).collect(Collectors.toSet());
    }

    public FieldInfo labelFieldOrNull() {
        if (this.labelFieldMapped) {
            return this.labelField;
        }
        if (!this.labelFieldMapped) {
            for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                if (!fieldInfo.isLabelField()) continue;
                if (!fieldInfo.isIterable()) {
                    throw new MappingException(String.format("Field '%s' in class '%s' includes the @Labels annotation, however this field is not a type of collection.", fieldInfo.getName(), this.name()));
                }
                this.labelFieldMapped = true;
                this.labelField = fieldInfo;
                return this.labelField;
            }
            this.labelFieldMapped = true;
        }
        return null;
    }

    public boolean isRelationshipEntity() {
        for (AnnotationInfo info : this.annotations()) {
            if (!info.getName().equals(RelationshipEntity.class.getName())) continue;
            return true;
        }
        return false;
    }

    public Collection<FieldInfo> propertyFields() {
        if (this.fieldInfos == null) {
            this.initPropertyFields();
        }
        return this.fieldInfos;
    }

    public FieldInfo propertyField(String propertyName) {
        if (this.propertyFields == null) {
            this.initPropertyFields();
        }
        return this.propertyFields.get(propertyName.toLowerCase());
    }

    private synchronized void initPropertyFields() {
        if (this.fieldInfos == null) {
            Collection<FieldInfo> fields = this.fieldsInfo().fields();
            FieldInfo identityField = this.identityFieldOrNull();
            HashSet<FieldInfo> fieldInfos = new HashSet<FieldInfo>(fields.size());
            HashMap<String, FieldInfo> propertyFields = new HashMap<String, FieldInfo>(fields.size());
            for (FieldInfo fieldInfo : fields) {
                if (fieldInfo == identityField || fieldInfo.isLabelField() || fieldInfo.hasAnnotation(StartNode.class) || fieldInfo.hasAnnotation(EndNode.class)) continue;
                AnnotationInfo annotationInfo = fieldInfo.getAnnotations().get(Property.class);
                if (annotationInfo == null) {
                    if (!fieldInfo.persistableAsProperty()) continue;
                    fieldInfos.add(fieldInfo);
                    propertyFields.put(fieldInfo.property().toLowerCase(), fieldInfo);
                    continue;
                }
                fieldInfos.add(fieldInfo);
                propertyFields.put(fieldInfo.property().toLowerCase(), fieldInfo);
            }
            this.fieldInfos = fieldInfos;
            this.propertyFields = propertyFields;
        }
    }

    public FieldInfo propertyFieldByName(String propertyName) {
        for (FieldInfo fieldInfo : this.propertyFields()) {
            if (!fieldInfo.getName().equalsIgnoreCase(propertyName)) continue;
            return fieldInfo;
        }
        return null;
    }

    public Collection<FieldInfo> relationshipFields() {
        FieldInfo identityField = this.identityFieldOrNull();
        HashSet<FieldInfo> fieldInfos = new HashSet<FieldInfo>();
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (fieldInfo == identityField) continue;
            AnnotationInfo annotationInfo = fieldInfo.getAnnotations().get(Relationship.class);
            if (annotationInfo == null) {
                if (fieldInfo.persistableAsProperty()) continue;
                fieldInfos.add(fieldInfo);
                continue;
            }
            fieldInfos.add(fieldInfo);
        }
        return fieldInfos;
    }

    public FieldInfo relationshipField(String relationshipName) {
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            if (!fieldInfo.relationship().equalsIgnoreCase(relationshipName)) continue;
            return fieldInfo;
        }
        return null;
    }

    public FieldInfo relationshipField(String relationshipName, String relationshipDirection, boolean strict) {
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            String relationship = strict ? fieldInfo.relationshipTypeAnnotation() : fieldInfo.relationship();
            if (!relationshipName.equalsIgnoreCase(relationship) || (!fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !fieldInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            return fieldInfo;
        }
        return null;
    }

    public Set<FieldInfo> candidateRelationshipFields(String relationshipName, String relationshipDirection, boolean strict) {
        HashSet<FieldInfo> candidateFields = new HashSet<FieldInfo>();
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            String relationship = strict ? fieldInfo.relationshipTypeAnnotation() : fieldInfo.relationship();
            if (!relationshipName.equalsIgnoreCase(relationship) || (!fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !fieldInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            candidateFields.add(fieldInfo);
        }
        return candidateFields;
    }

    public FieldInfo relationshipFieldByName(String fieldName) {
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            if (!fieldInfo.getName().equalsIgnoreCase(fieldName)) continue;
            return fieldInfo;
        }
        return null;
    }

    public Field getField(FieldInfo fieldInfo) {
        Field field = this.fieldInfoFields.get(fieldInfo);
        if (field != null) {
            return field;
        }
        try {
            field = this.cls.getDeclaredField(fieldInfo.getName());
            this.fieldInfoFields.put(fieldInfo, field);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (this.directSuperclass() != null) {
                field = this.directSuperclass().getField(fieldInfo);
                this.fieldInfoFields.put(fieldInfo, field);
                return field;
            }
            throw new RuntimeException("Field " + fieldInfo.getName() + " not found in class " + this.name() + " or any of its superclasses");
        }
    }

    public Method getMethod(MethodInfo methodInfo) {
        return methodInfo.getMethod();
    }

    public List<FieldInfo> findFields(Class<?> fieldType) {
        String fieldSignature = fieldType.getName();
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (!fieldInfo.getTypeDescriptor().equals(fieldSignature)) continue;
            fieldInfos.add(fieldInfo);
        }
        return fieldInfos;
    }

    public List<FieldInfo> findFields(String annotation) {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (!fieldInfo.hasAnnotation(annotation)) continue;
            fieldInfos.add(fieldInfo);
        }
        return fieldInfos;
    }

    public List<FieldInfo> findIterableFields() {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        try {
            for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                Class<?> type = this.getField(fieldInfo).getType();
                if (!type.isArray() && !Iterable.class.isAssignableFrom(type)) continue;
                fieldInfos.add(fieldInfo);
            }
            return fieldInfos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<FieldInfo> findIterableFields(Class iteratedType) {
        if (this.iterableFieldsForType.containsKey(iteratedType)) {
            return this.iterableFieldsForType.get(iteratedType);
        }
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        String typeSignature = iteratedType.getName();
        String arrayOfTypeSignature = typeSignature + "[]";
        try {
            for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                String fieldType = fieldInfo.getTypeDescriptor();
                if (fieldInfo.isArray() && (fieldType.equals(arrayOfTypeSignature) || fieldInfo.isParameterisedTypeOf(iteratedType))) {
                    fieldInfos.add(fieldInfo);
                    continue;
                }
                if (!fieldInfo.isIterable() || !fieldType.equals(typeSignature) && !fieldInfo.isParameterisedTypeOf(iteratedType)) continue;
                fieldInfos.add(fieldInfo);
            }
            this.iterableFieldsForType.put(iteratedType, fieldInfos);
            return fieldInfos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<FieldInfo> findIterableFields(Class iteratedType, String relationshipType, String relationshipDirection, boolean strict) {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        for (FieldInfo fieldInfo : this.findIterableFields(iteratedType)) {
            String relationship = strict ? fieldInfo.relationshipTypeAnnotation() : fieldInfo.relationship();
            if (!relationshipType.equals(relationship) || (!fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !fieldInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            fieldInfos.add(fieldInfo);
        }
        return fieldInfos;
    }

    public boolean isTransient() {
        return this.annotationsInfo.get(Transient.class) != null;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    boolean isSubclassOf(ClassInfo classInfo) {
        ClassInfo subclass;
        if (this == classInfo) {
            return true;
        }
        boolean found = false;
        Iterator<ClassInfo> iterator = classInfo.directSubclasses().iterator();
        while (iterator.hasNext() && !(found = this.isSubclassOf(subclass = iterator.next()))) {
        }
        return found;
    }

    public Class<?> getUnderlyingClass() {
        return this.cls;
    }

    Class getTypeParameterDescriptorForRelationship(String relationshipType, String relationshipDirection) {
        boolean STRICT_MODE = true;
        boolean INFERRED_MODE = false;
        try {
            FieldInfo fieldInfo = this.relationshipField(relationshipType, relationshipDirection, true);
            if (fieldInfo != null && fieldInfo.getTypeDescriptor() != null) {
                return ClassUtils.getType(fieldInfo.getTypeDescriptor());
            }
            if (!relationshipDirection.equals("INCOMING") && (fieldInfo = this.relationshipField(relationshipType, relationshipDirection, false)) != null && fieldInfo.getTypeDescriptor() != null) {
                return ClassUtils.getType(fieldInfo.getTypeDescriptor());
            }
        }
        catch (RuntimeException e) {
            LOGGER.debug("Could not get {} class type for relationshipType {} and relationshipDirection {} ", new Object[]{this.className, relationshipType, relationshipDirection});
        }
        return null;
    }

    public boolean containsIndexes() {
        return !this.getIndexFields().isEmpty();
    }

    public Collection<FieldInfo> getIndexFields() {
        if (this.indexFields == null) {
            this.indexFields = this.addIndexes();
        }
        return this.indexFields.values();
    }

    private Map<String, FieldInfo> addIndexes() {
        Field[] declaredFields;
        HashMap<String, FieldInfo> indexes = new HashMap<String, FieldInfo>();
        try {
            declaredFields = Class.forName(this.className, false, Thread.currentThread().getContextClassLoader()).getDeclaredFields();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not reflectively read declared fields", e);
        }
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (!ClassInfo.isDeclaredField(declaredFields, fieldInfo.getName()) || !fieldInfo.hasAnnotation(Index.class) && !fieldInfo.hasAnnotation(Id.class)) continue;
            String propertyValue = fieldInfo.property();
            if (fieldInfo.hasAnnotation(Property.class.getName())) {
                propertyValue = fieldInfo.property();
            }
            indexes.put(propertyValue, fieldInfo);
        }
        return indexes;
    }

    private static boolean isDeclaredField(Field[] declaredFields, String name) {
        for (Field field : declaredFields) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public FieldInfo primaryIndexField() {
        if (!this.primaryIndexFieldChecked && this.primaryIndexField == null) {
            Collection<FieldInfo> primaryIndexFields = this.getFieldInfos(this::isPrimaryIndexField);
            if (primaryIndexFields.size() > 1) {
                throw new MetadataException("Only one @Id / @Index(primary=true, unique=true) annotation is allowed in a class hierarchy. Please check annotations in the class " + this.name() + " or its parents");
            }
            if (primaryIndexFields.size() == 1) {
                this.primaryIndexField = primaryIndexFields.iterator().next();
                AnnotationInfo generatedValueAnnotation = this.primaryIndexField.getAnnotations().get(GeneratedValue.class);
                if (generatedValueAnnotation != null) {
                    GeneratedValue value = (GeneratedValue)generatedValueAnnotation.getAnnotation();
                    this.idStrategyClass = value.strategy();
                    this.instantiateIdStrategy();
                }
            }
            this.validateIdGenerationConfig();
            this.primaryIndexFieldChecked = true;
        }
        return this.primaryIndexField;
    }

    public boolean hasPrimaryIndexField() {
        if (!this.primaryIndexFieldChecked) {
            this.primaryIndexField();
        }
        return this.primaryIndexField != null;
    }

    private boolean isPrimaryIndexField(FieldInfo fieldInfo) {
        return fieldInfo.getAnnotations().has(Id.class) && (!fieldInfo.getAnnotations().has(GeneratedValue.class) || !((GeneratedValue)fieldInfo.getAnnotations().get(GeneratedValue.class).getAnnotation()).strategy().equals(InternalIdStrategy.class)) || fieldInfo.getAnnotations().has(Index.class) && ((Index)fieldInfo.getAnnotations().get(Index.class).getAnnotation()).primary();
    }

    private void instantiateIdStrategy() {
        try {
            this.idStrategy = this.idStrategyClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.debug("Could not instantiate {}. Expecting this to be registered manually.", this.idStrategyClass);
        }
    }

    private void validateIdGenerationConfig() {
        this.fieldsInfo().fields().forEach(info -> {
            if (info.hasAnnotation(GeneratedValue.class) && !info.hasAnnotation(Id.class)) {
                throw new MetadataException("The type of @Generated field in class " + this.className + " must be also annotated with @Id.");
            }
        });
        if (UuidStrategy.class.equals(this.idStrategyClass) && !this.primaryIndexField.isTypeOf(UUID.class) && !this.primaryIndexField.isTypeOf(String.class)) {
            throw new MetadataException("The type of " + this.primaryIndexField.getName() + " in class " + this.className + " must be of type java.lang.UUID or java.lang.String because it has an UUID generation strategy.");
        }
    }

    public IdStrategy idStrategy() {
        if (!this.primaryIndexFieldChecked) {
            this.primaryIndexField();
        }
        return this.idStrategy;
    }

    public Class<? extends IdStrategy> idStrategyClass() {
        return this.idStrategyClass;
    }

    public void registerIdGenerationStrategy(IdStrategy strategy) {
        if (!strategy.getClass().equals(this.idStrategyClass)) {
            throw new IllegalArgumentException("Strategy " + strategy + " is not an instance of " + this.idStrategyClass);
        }
        this.idStrategy = strategy;
    }

    public MethodInfo postLoadMethodOrNull() {
        if (this.isPostLoadMethodMapped) {
            return this.postLoadMethod;
        }
        if (!this.isPostLoadMethodMapped) {
            for (MethodInfo methodInfo : this.methodsInfo().methods()) {
                if (!methodInfo.hasAnnotation(PostLoad.class.getName())) continue;
                this.isPostLoadMethodMapped = true;
                this.postLoadMethod = methodInfo;
                return this.postLoadMethod;
            }
            this.isPostLoadMethodMapped = true;
        }
        return null;
    }

    public FieldInfo getFieldInfo(String propertyName) {
        FieldInfo labelField = this.labelFieldOrNull();
        if (labelField != null && labelField.getName().equals(propertyName)) {
            return labelField;
        }
        FieldInfo propertyField = this.propertyField(propertyName);
        if (propertyField != null) {
            return propertyField;
        }
        return null;
    }

    public FieldInfo getEndNodeReader() {
        if (this.isRelationshipEntity()) {
            for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                if (fieldInfo.getAnnotations().get(EndNode.class) == null) continue;
                return fieldInfo;
            }
            LOGGER.warn("Failed to find an @EndNode on {}", (Object)this.name());
        }
        return null;
    }

    public FieldInfo getStartNodeReader() {
        if (this.isRelationshipEntity()) {
            for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                if (fieldInfo.getAnnotations().get(StartNode.class) == null) continue;
                return fieldInfo;
            }
            LOGGER.warn("Failed to find an @StartNode on {}", (Object)this.name());
        }
        return null;
    }
}

