/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler.builders.statement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.neo4j.ogm.cypher.compiler.CypherStatementBuilder;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;

public class NewRelationshipStatementBuilder
implements CypherStatementBuilder {
    private final StatementFactory statementFactory;
    private final Set<Edge> edges;

    public NewRelationshipStatementBuilder(Set<Edge> edges, StatementFactory statementFactory) {
        this.edges = edges;
        this.statementFactory = statementFactory;
    }

    @Override
    public Statement build() {
        HashMap parameters = new HashMap();
        StringBuilder queryBuilder = new StringBuilder();
        boolean hasProperties = false;
        if (this.edges != null && this.edges.size() > 0) {
            Edge firstEdge = this.edges.iterator().next();
            String relType = firstEdge.getType();
            hasProperties = firstEdge.getPropertyList().size() > 0;
            boolean hasPrimaryId = firstEdge.getPrimaryIdName() != null;
            queryBuilder.append("UNWIND {rows} as row ").append("MATCH (startNode) WHERE ID(startNode) = row.startNodeId ").append("MATCH (endNode) WHERE ID(endNode) = row.endNodeId ");
            if (hasProperties && !hasPrimaryId) {
                queryBuilder.append("CREATE ");
            } else {
                queryBuilder.append("MERGE ");
            }
            queryBuilder.append("(startNode)-[rel:`").append(relType).append("`");
            if (hasPrimaryId) {
                queryBuilder.append(" {`").append(firstEdge.getPrimaryIdName()).append("`: row.props.`").append(firstEdge.getPrimaryIdName()).append("`}");
            }
            queryBuilder.append("]->(endNode) ");
            if (hasProperties) {
                queryBuilder.append("SET rel += row.props ");
            }
            queryBuilder.append("RETURN row.relRef as ref, ID(rel) as id, row.type as type");
            ArrayList rows = new ArrayList();
            for (Edge edge : this.edges) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put("startNodeId", edge.getStartNode());
                rowMap.put("endNodeId", edge.getEndNode());
                rowMap.put("relRef", edge.getId());
                rowMap.put("type", "rel");
                if (hasProperties) {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    for (Property property : edge.getPropertyList()) {
                        props.put((String)property.getKey(), property.getValue());
                    }
                    rowMap.put("props", props);
                } else {
                    rowMap.put("props", Collections.emptyMap());
                }
                rows.add(rowMap);
            }
            parameters.put("rows", rows);
        }
        return this.statementFactory.statement(queryBuilder.toString(), parameters);
    }
}

