/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler.builders.statement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.neo4j.ogm.cypher.compiler.CypherStatementBuilder;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;

public class NewNodeStatementBuilder
implements CypherStatementBuilder {
    private final StatementFactory statementFactory;
    private final Set<Node> newNodes;

    public NewNodeStatementBuilder(Set<Node> newNodes, StatementFactory statementFactory) {
        this.newNodes = newNodes;
        this.statementFactory = statementFactory;
    }

    @Override
    public Statement build() {
        HashMap parameters = new HashMap();
        StringBuilder queryBuilder = new StringBuilder();
        if (this.newNodes != null && this.newNodes.size() > 0) {
            Node firstNode = this.newNodes.iterator().next();
            queryBuilder.append("UNWIND {rows} as row ");
            if (firstNode.getPrimaryIndex() != null) {
                queryBuilder.append("MERGE (n");
            } else {
                queryBuilder.append("CREATE (n");
            }
            for (String label : firstNode.getLabels()) {
                queryBuilder.append(":`").append(label).append("`");
            }
            if (firstNode.getPrimaryIndex() != null) {
                queryBuilder.append("{").append(firstNode.getPrimaryIndex()).append(": row.props.").append(firstNode.getPrimaryIndex()).append("}");
            }
            queryBuilder.append(") SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, row.type as type");
            ArrayList rows = new ArrayList();
            for (Node node : this.newNodes) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put("nodeRef", node.getId());
                rowMap.put("type", "node");
                HashMap<String, Object> props = new HashMap<String, Object>();
                for (Property property : node.getPropertyList()) {
                    if (property.getValue() == null) continue;
                    props.put((String)property.getKey(), property.getValue());
                }
                rowMap.put("props", props);
                rows.add(rowMap);
            }
            parameters.put("rows", rows);
        }
        return this.statementFactory.statement(queryBuilder.toString(), parameters);
    }
}

