/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler.builders.node;

import java.util.Map;
import org.neo4j.ogm.cypher.compiler.RelationshipBuilder;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.response.model.PropertyModel;
import org.neo4j.ogm.response.model.RelationshipModel;

public class DefaultRelationshipBuilder
implements RelationshipBuilder {
    RelationshipModel relationship = new RelationshipModel();
    private String direction;
    private boolean singleton = true;
    private boolean bidirectional = false;
    private boolean relationshipEntity = false;

    public DefaultRelationshipBuilder(String type, boolean bidirectional) {
        this.relationship.setType(type);
        this.relationship.setId(Long.valueOf(-System.identityHashCode(this.relationship)));
        this.bidirectional = bidirectional;
    }

    public DefaultRelationshipBuilder(String type, Long relationshipId) {
        if (relationshipId == null) {
            relationshipId = -System.identityHashCode(this.relationship);
        }
        this.relationship.setId(relationshipId);
        this.relationship.setType(type);
    }

    @Override
    public Long reference() {
        return this.relationship.getId();
    }

    @Override
    public void setType(String type) {
        this.relationship.setType(type);
    }

    @Override
    public void addProperty(String key, Object value) {
        this.relationship.getPropertyList().add(new PropertyModel((Object)key, value));
    }

    @Override
    public void addProperties(Map<String, ?> properties) {
        for (String key : properties.keySet()) {
            this.addProperty(key, properties.get(key));
        }
    }

    @Override
    public void relate(Long startNodeId, Long endNodeId) {
        this.relationship.setStartNode(startNodeId);
        this.relationship.setEndNode(endNodeId);
    }

    @Override
    public String type() {
        return this.relationship.getType();
    }

    @Override
    public boolean hasDirection(String direction) {
        return this.direction != null && this.direction.equals(direction);
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public boolean isNew() {
        return true;
    }

    @Override
    public void setSingleton(boolean b) {
        this.singleton = b;
    }

    @Override
    public boolean isRelationshipEntity() {
        return this.relationshipEntity;
    }

    @Override
    public void setRelationshipEntity(boolean relationshipEntity) {
        this.relationshipEntity = relationshipEntity;
    }

    @Override
    public RelationshipBuilder direction(String direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public boolean isBidirectional() {
        return this.bidirectional;
    }

    @Override
    public Edge edge() {
        return this.relationship;
    }

    @Override
    public void setReference(Long reference) {
        this.relationship.setId(reference);
    }

    @Override
    public void setPrimaryIdName(String primaryIdName) {
        this.relationship.setPrimaryIdName(primaryIdName);
    }
}

