/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.util.Map;
import org.neo4j.ogm.metadata.schema.Node;
import org.neo4j.ogm.metadata.schema.Relationship;
import org.neo4j.ogm.metadata.schema.Schema;
import org.neo4j.ogm.session.request.strategy.LoadClauseBuilder;

public class SchemaLoadClauseBuilder
implements LoadClauseBuilder {
    private final Schema schema;
    private final boolean pretty;

    public SchemaLoadClauseBuilder(Schema schema) {
        this.schema = schema;
        this.pretty = false;
    }

    @Override
    public String build(String variable, String label, int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Only queries with depth >= 0 can be built, depth=" + depth);
        }
        StringBuilder sb = new StringBuilder();
        this.newLine(sb);
        sb.append(" RETURN ");
        this.newLine(sb);
        sb.append("n");
        this.newLine(sb);
        if (depth > 0) {
            Node node = this.schema.findNode(label);
            if (node.relationships().size() > 0) {
                sb.append(",[ ");
            }
            this.expand(sb, variable, node, 1, depth - 1);
            if (node.relationships().size() > 0) {
                sb.append(" ]");
            }
        }
        return sb.toString();
    }

    private void expand(StringBuilder sb, String fromNodeVar, Node node, int level, int depth) {
        for (Map.Entry<String, Relationship> entry : node.relationships().entrySet()) {
            if (this.needsSeparator(sb)) {
                sb.append(", ");
            }
            this.listComprehension(sb, fromNodeVar, entry.getValue(), node, level, depth);
        }
    }

    private boolean needsSeparator(StringBuilder sb) {
        for (int i = sb.length() - 1; i >= 0; --i) {
            char ch = sb.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return ch != '[' && ch != ',';
        }
        return false;
    }

    private void listComprehension(StringBuilder sb, String fromNodeVar, Relationship relationship, Node node, int level, int depth) {
        String direction = relationship.direction(node);
        Node toNode = relationship.other(node);
        String relVar = this.relVariableName(relationship, level);
        String toNodeVar = this.variableName(toNode, level);
        sb.append("[ (");
        sb.append(fromNodeVar);
        sb.append(")");
        switch (direction) {
            case "INCOMING": {
                this.appendRel(sb, relVar, relationship.type(), "<-[", "]-");
                break;
            }
            case "OUTGOING": {
                this.appendRel(sb, relVar, relationship.type(), "-[", "]->");
                break;
            }
            default: {
                this.appendRel(sb, relVar, relationship.type(), "-[", "]-");
            }
        }
        sb.append("(");
        sb.append(toNodeVar);
        sb.append(":`");
        sb.append(toNode.label());
        sb.append("`) | [ ");
        sb.append(relVar);
        sb.append(", ");
        sb.append(toNodeVar);
        if (depth > 0 && !toNode.relationships().isEmpty()) {
            sb.append(", [ ");
            this.expand(sb, toNodeVar, toNode, level + 1, depth - 1);
            sb.append(" ]");
        }
        sb.append(" ] ]");
    }

    private String relVariableName(Relationship relationship, int level) {
        return "r_" + Character.toLowerCase(relationship.type().charAt(0)) + level;
    }

    private String variableName(Node node, int level) {
        return "" + Character.toLowerCase(node.label().charAt(0)) + level;
    }

    private void appendRel(StringBuilder sb, String variable, String type, String start, String end) {
        sb.append(start).append(variable).append(":`").append(type).append("`").append(end);
    }

    private void newLine(StringBuilder sb) {
        if (this.pretty) {
            sb.append("\n");
        }
    }
}

