/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.session.request.FilteredQuery;
import org.neo4j.ogm.session.request.FilteredQueryBuilder;
import org.neo4j.ogm.session.request.strategy.LoadClauseBuilder;
import org.neo4j.ogm.session.request.strategy.MatchClauseBuilder;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.session.request.strategy.impl.IdCollectionMatchClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.IdMatchClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.LabelMatchClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.PathLoadClauseBuilder;

public class NodeQueryStatements<ID extends Serializable>
implements QueryStatements<ID> {
    private String primaryIndex;
    private MatchClauseBuilder idMatchClauseBuilder = new IdMatchClauseBuilder();
    private MatchClauseBuilder idCollectionMatchClauseBuilder = new IdCollectionMatchClauseBuilder();
    private MatchClauseBuilder labelMatchClauseBuilder = new LabelMatchClauseBuilder();
    private LoadClauseBuilder loadClauseBuilder;

    public NodeQueryStatements() {
        this.loadClauseBuilder = new PathLoadClauseBuilder();
    }

    public NodeQueryStatements(String primaryIndex, LoadClauseBuilder loadClauseBuilder) {
        this.primaryIndex = primaryIndex;
        this.loadClauseBuilder = Objects.requireNonNull(loadClauseBuilder);
    }

    @Override
    public PagingAndSortingQuery findOne(ID id, int depth) {
        return this.findOneByType("", id, depth);
    }

    @Override
    public PagingAndSortingQuery findOneByType(String label, ID id, int depth) {
        String matchClause = this.primaryIndex != null ? this.idMatchClauseBuilder.build(label, this.primaryIndex) : this.idMatchClauseBuilder.build(label);
        String returnClause = this.loadClauseBuilder.build(label, depth);
        return new PagingAndSortingQuery(matchClause, returnClause, Utils.map("id", id), depth != 0, false);
    }

    @Override
    public PagingAndSortingQuery findAllByType(String label, Collection<ID> ids, int depth) {
        String matchClause = this.primaryIndex != null ? this.idCollectionMatchClauseBuilder.build(label, this.primaryIndex) : this.idCollectionMatchClauseBuilder.build(label);
        String returnClause = this.loadClauseBuilder.build(label, depth);
        return new PagingAndSortingQuery(matchClause, returnClause, Utils.map("ids", ids), depth != 0, false);
    }

    @Override
    public PagingAndSortingQuery findByType(String label, int depth) {
        String matchClause = this.labelMatchClauseBuilder.build(label);
        String returnClause = this.loadClauseBuilder.build(label, depth);
        return new PagingAndSortingQuery(matchClause, returnClause, Utils.map(new Object[0]), depth != 0, false);
    }

    @Override
    public PagingAndSortingQuery findByType(String label, Filters parameters, int depth) {
        FilteredQuery filteredQuery = FilteredQueryBuilder.buildNodeQuery(label, parameters);
        String matchClause = filteredQuery.statement();
        String returnClause = this.loadClauseBuilder.build(label, depth);
        return new PagingAndSortingQuery(matchClause, returnClause, filteredQuery.parameters(), depth != 0, true);
    }
}

