/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.cypher.query.DefaultGraphModelRequest;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.utils.EntityUtils;

public class LoadByIdsDelegate {
    private final Neo4jSession session;

    public LoadByIdsDelegate(Neo4jSession session) {
        this.session = session;
    }

    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, SortOrder sortOrder, Pagination pagination, int depth) {
        String entityType = this.session.entityType(type.getName());
        QueryStatements<ID> queryStatements = this.session.queryStatementsFor(type, depth);
        PagingAndSortingQuery qry = queryStatements.findAllByType(entityType, ids, depth).setSortOrder(sortOrder).setPagination(pagination);
        DefaultGraphModelRequest request = new DefaultGraphModelRequest(qry.getStatement(), qry.getParameters());
        try (Response response = this.session.requestHandler().execute((GraphModelRequest)request);){
            Iterable<T> mapped = new GraphEntityMapper(this.session.metaData(), this.session.context()).map(type, (Response<GraphModel>)response);
            if (sortOrder.sortClauses().isEmpty()) {
                Set<T> set = this.sortResultsByIds(type, ids, mapped);
                return set;
            }
            LinkedHashSet<T> results = new LinkedHashSet<T>();
            for (T entity : mapped) {
                if (!this.includeMappedEntity(ids, entity)) continue;
                results.add(entity);
            }
            LinkedHashSet<T> linkedHashSet = results;
            return linkedHashSet;
        }
    }

    private <T, ID extends Serializable> Set<T> sortResultsByIds(Class<T> type, Collection<ID> ids, Iterable<T> mapped) {
        HashMap<Serializable, T> items = new HashMap<Serializable, T>();
        ClassInfo classInfo = this.session.metaData().classInfo(type.getName());
        FieldInfo idField = classInfo.primaryIndexField();
        if (idField == null) {
            idField = classInfo.identityField();
        }
        for (T t : mapped) {
            Object id = idField.read(t);
            if (id == null) continue;
            items.put((Serializable)id, t);
        }
        LinkedHashSet results = new LinkedHashSet();
        for (Object id : ids) {
            Object item = items.get(id);
            if (item == null) continue;
            results.add(item);
        }
        return results;
    }

    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids) {
        return this.loadAll(type, ids, new SortOrder(), null, 1);
    }

    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, int depth) {
        return this.loadAll(type, ids, new SortOrder(), null, depth);
    }

    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, SortOrder sortOrder) {
        return this.loadAll(type, ids, sortOrder, null, 1);
    }

    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, SortOrder sortOrder, int depth) {
        return this.loadAll(type, ids, sortOrder, null, depth);
    }

    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, Pagination paging) {
        return this.loadAll(type, ids, new SortOrder(), paging, 1);
    }

    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, Pagination paging, int depth) {
        return this.loadAll(type, ids, new SortOrder(), paging, depth);
    }

    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(type, ids, sortOrder, pagination, 1);
    }

    private <T, ID extends Serializable> boolean includeMappedEntity(Collection<ID> ids, T mapped) {
        Object primaryIndexValue;
        ClassInfo classInfo = this.session.metaData().classInfo(mapped);
        FieldInfo primaryIndexField = classInfo.primaryIndexField();
        if (primaryIndexField != null && ids.contains(primaryIndexValue = primaryIndexField.read(mapped))) {
            return true;
        }
        Long id = EntityUtils.identity(mapped, this.session.metaData());
        return ids.contains(id);
    }
}

