/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.ogm.autoindex.AutoIndexManager;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.exception.core.ConfigurationException;
import org.neo4j.ogm.id.IdStrategy;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.LoadStrategy;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.event.EventListener;

public class SessionFactory {
    private final MetaData metaData;
    private final Driver driver;
    private final List<EventListener> eventListeners;
    private LoadStrategy loadStrategy = LoadStrategy.SCHEMA_LOAD_STRATEGY;

    public SessionFactory(String ... packages) {
        this(new Configuration.Builder().build(), packages);
    }

    public SessionFactory(Configuration configuration, String ... packages) {
        this.metaData = new MetaData(packages);
        this.driver = this.newDriverInstance(configuration.getDriverClassName());
        this.driver.configure(configuration);
        AutoIndexManager autoIndexManager = new AutoIndexManager(this.metaData, this.driver, configuration);
        autoIndexManager.build();
        this.eventListeners = new CopyOnWriteArrayList<EventListener>();
    }

    private Driver newDriverInstance(String driverClassName) {
        try {
            Class<?> driverClass = Class.forName(driverClassName);
            return (Driver)driverClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Could not load driver class " + driverClassName, e);
        }
    }

    public SessionFactory(Driver driver, String ... packages) {
        this.metaData = new MetaData(packages);
        this.driver = driver;
        this.eventListeners = new CopyOnWriteArrayList<EventListener>();
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public Session openSession() {
        return new Neo4jSession(this.metaData, this.driver, this.eventListeners, this.loadStrategy);
    }

    public void register(EventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    public void deregister(EventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public void setLoadStrategy(LoadStrategy loadStrategy) {
        this.loadStrategy = loadStrategy;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void close() {
        this.driver.close();
    }

    public void register(IdStrategy strategy) {
        Objects.requireNonNull(strategy);
        for (ClassInfo classInfo : this.metaData.persistentEntities()) {
            if (!strategy.getClass().equals(classInfo.idStrategyClass())) continue;
            classInfo.registerIdGenerationStrategy(strategy);
        }
    }
}

