/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.schema;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.metadata.schema.Node;
import org.neo4j.ogm.metadata.schema.Relationship;
import org.neo4j.ogm.utils.RelationshipUtils;

class NodeImpl
implements Node {
    private final String label;
    private final Collection<String> labels;
    private final Map<String, Relationship> relationships = new HashMap<String, Relationship>();

    public NodeImpl(String label, Collection<String> labels) {
        this.label = label;
        this.labels = labels;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public Collection<String> labels() {
        return this.labels;
    }

    @Override
    public Map<String, Relationship> relationships() {
        return this.relationships;
    }

    void addRelationship(Relationship relationship) {
        this.relationships.put(RelationshipUtils.inferFieldName(relationship.type()), relationship);
    }

    void addRelationship(String name, Relationship relationship) {
        this.relationships.put(name, relationship);
    }

    public String toString() {
        return "NodeImpl{label='" + this.label + '\'' + ", labels=" + this.labels + '}';
    }
}

