/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.schema;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DomainInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.reflect.GenericUtils;
import org.neo4j.ogm.metadata.schema.NodeImpl;
import org.neo4j.ogm.metadata.schema.RelationshipImpl;
import org.neo4j.ogm.metadata.schema.Schema;
import org.neo4j.ogm.metadata.schema.SchemaImpl;
import org.neo4j.ogm.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainInfoSchemaBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DomainInfoSchemaBuilder.class);
    private DomainInfo domainInfo;
    private Map<String, ClassInfo> classInfoMap;
    private SchemaImpl schema;

    public DomainInfoSchemaBuilder(DomainInfo domainInfo) {
        this.domainInfo = domainInfo;
        this.classInfoMap = domainInfo.getClassInfoMap();
        this.schema = new SchemaImpl();
    }

    public Schema build() {
        this.buildNodes();
        this.buildRelationships();
        return this.schema;
    }

    private void buildNodes() {
        for (ClassInfo classInfo : this.classInfoMap.values()) {
            if (classInfo.isRelationshipEntity()) continue;
            String label = classInfo.neo4jName();
            NodeImpl node = new NodeImpl(classInfo.neo4jName(), classInfo.staticLabels());
            this.schema.addNode(label, node);
        }
    }

    private void buildRelationships() {
        for (ClassInfo classInfo : this.classInfoMap.values()) {
            if (classInfo.isRelationshipEntity()) continue;
            String label = classInfo.neo4jName();
            NodeImpl node = (NodeImpl)this.schema.findNode(label);
            Collection<FieldInfo> relationships = classInfo.relationshipFields();
            for (FieldInfo fieldInfo : relationships) {
                this.createRelationship(node, fieldInfo);
            }
        }
    }

    private void createRelationship(NodeImpl fromNode, FieldInfo relFieldInfo) {
        NodeImpl toNode;
        Class<?> otherClass = ClassUtils.getType(relFieldInfo.getTypeDescriptor());
        String otherType = otherClass.getName();
        ClassInfo otherClassInfo = this.classInfoMap.get(otherType);
        if (otherClassInfo == null) {
            logger.debug("Type " + otherType + " not found. Did you specify 'packages' parameter to SessionFactory correctly?");
            return;
        }
        if (otherClassInfo.isRelationshipEntity()) {
            if (relFieldInfo.relationshipDirection().equals("OUTGOING")) {
                Field endField = otherClassInfo.getEndNodeReader().getField();
                Class endType = GenericUtils.findFieldType(endField, otherClassInfo.getUnderlyingClass());
                toNode = this.getNodeByTypeDescriptor(endType.getName());
            } else {
                Field startField = otherClassInfo.getStartNodeReader().getField();
                Class startType = GenericUtils.findFieldType(startField, otherClassInfo.getUnderlyingClass());
                toNode = this.getNodeByTypeDescriptor(startType.getName());
            }
        } else {
            toNode = (NodeImpl)this.schema.findNode(otherClassInfo.neo4jName());
        }
        RelationshipImpl relationship = new RelationshipImpl(relFieldInfo.relationshipType(), relFieldInfo.relationshipDirection(), fromNode, toNode);
        fromNode.addRelationship(relFieldInfo.getName(), relationship);
    }

    private NodeImpl getNodeByTypeDescriptor(String typeDescriptor) {
        ClassInfo classInfo = this.classInfoMap.get(typeDescriptor);
        return (NodeImpl)this.schema.findNode(classInfo.neo4jName());
    }
}

