/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.query;

import java.util.Map;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.PagingAndSorting;
import org.neo4j.ogm.cypher.query.SortOrder;

public class PagingAndSortingQuery
implements PagingAndSorting {
    private Pagination paging;
    private SortOrder sortOrder = new SortOrder();
    private String statement;
    private String matchClause;
    private String returnClause;
    private final Map<String, Object> parameters;
    protected int withIndex;
    private boolean returnsPath = false;
    private boolean hasPredicate;

    public PagingAndSortingQuery(String statement, Map<String, Object> parameters) {
        this.statement = statement;
        this.parameters = parameters;
        this.withIndex = this.statement.indexOf("WITH n");
        if (this.withIndex == -1) {
            this.withIndex = this.statement.indexOf("WITH r");
        }
        this.hasPredicate = statement.contains("WHERE");
        this.returnsPath = statement.matches(".*RETURN.*p.*");
    }

    public PagingAndSortingQuery(String matchClause, String returnClause, Map<String, Object> parameters, boolean returnsPath, boolean hasPredicate) {
        this.matchClause = matchClause;
        this.returnClause = returnClause;
        this.parameters = parameters;
        this.returnsPath = returnsPath;
        this.hasPredicate = hasPredicate;
    }

    public String getStatement() {
        String pagination;
        String sorting = this.sortOrder().toString();
        if (this.statement == null) {
            StringBuilder sb = new StringBuilder();
            String returnClause = this.returnClause;
            sb.append(this.matchClause);
            if (!sorting.isEmpty()) {
                sb.append(sorting.replace("$", "n"));
            }
            if (this.paging != null) {
                sb.append(this.paging.toString());
            }
            sb.append(returnClause);
            if (this.needsRowResult()) {
                sb.append(", ID(n)");
            }
            return sb.toString();
        }
        String stmt = this.statement.trim();
        String string = pagination = this.paging == null ? "" : this.page().toString();
        if (sorting.length() > 0 || pagination.length() > 0) {
            if (this.withIndex > -1) {
                String withClause;
                int nextClauseIndex = stmt.indexOf(" MATCH", this.withIndex);
                String newWithClause = withClause = stmt.substring(this.withIndex, nextClauseIndex);
                if (stmt.contains(")-[r0")) {
                    sorting = sorting.replace("$", "r0");
                    if (!withClause.contains(",r0") && !withClause.contains("r0,")) {
                        newWithClause = newWithClause + ",r0";
                    }
                } else {
                    sorting = sorting.replace("$", "n");
                }
                if ((stmt = stmt.replace(withClause, newWithClause + sorting + pagination)).contains("MATCH p=(") && !stmt.contains("RETURN p, ID(n)")) {
                    stmt = stmt.replace("RETURN p", "RETURN p, ID(n)");
                }
            } else {
                if (stmt.startsWith("MATCH p=(")) {
                    String withClause = "WITH p";
                    if (stmt.contains(")-[r")) {
                        withClause = withClause + ",r0";
                        sorting = sorting.replace("$", "r0");
                    } else {
                        sorting = sorting.replace("$", "n");
                    }
                    stmt = stmt.replace("RETURN ", withClause + sorting + pagination + " RETURN ");
                } else {
                    sorting = sorting.replace("$", "n");
                    stmt = stmt.replace("RETURN ", "WITH n" + sorting + pagination + " RETURN ");
                }
                if (stmt.contains("MATCH p=(") && stmt.contains("WITH n") && !stmt.contains("RETURN p, ID(n)")) {
                    stmt = stmt.replace("RETURN p", "RETURN p, ID(n)");
                }
            }
        }
        return stmt;
    }

    public boolean needsRowResult() {
        return (this.sortOrder.toString().length() > 0 || this.paging != null || this.hasPredicate) && this.returnsPath;
    }

    @Override
    public PagingAndSortingQuery setPagination(Pagination paging) {
        this.paging = paging;
        return this;
    }

    @Override
    public PagingAndSortingQuery setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public void setReturnsPath(boolean returnsPath) {
        this.returnsPath = returnsPath;
    }

    private Pagination page() {
        return this.paging;
    }

    private SortOrder sortOrder() {
        return this.sortOrder;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

