/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.compiler.SrcTargetKey;
import org.neo4j.ogm.context.Mappable;
import org.neo4j.ogm.cypher.compiler.CompileContext;
import org.neo4j.ogm.cypher.compiler.Compiler;
import org.neo4j.ogm.cypher.compiler.NodeBuilder;

public class CypherContext
implements CompileContext {
    private final Map<Object, NodeBuilder> visitedObjects = new IdentityHashMap<Object, NodeBuilder>();
    private final Set<Long> visitedRelationshipEntities = new HashSet<Long>();
    private final Map<Long, Object> createdObjectsWithId = new HashMap<Long, Object>();
    private final Collection<Mappable> registeredRelationships = new HashSet<Mappable>();
    private final Collection<Mappable> deletedRelationships = new HashSet<Mappable>();
    private final Map<Long, Long> newNodeIds = new HashMap<Long, Long>();
    private final Collection<Object> log = new HashSet<Object>();
    private final Map<SrcTargetKey, Collection<Object>> transientRelsIndex = new HashMap<SrcTargetKey, Collection<Object>>();
    private final Compiler compiler;

    public CypherContext(Compiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public boolean visited(Object entity) {
        return this.visitedObjects.containsKey(entity);
    }

    @Override
    public void visit(Object entity, NodeBuilder nodeBuilder) {
        this.visitedObjects.put(entity, nodeBuilder);
    }

    @Override
    public void registerRelationship(Mappable mappedRelationship) {
        this.registeredRelationships.add(mappedRelationship);
    }

    @Override
    public boolean removeRegisteredRelationship(Mappable mappedRelationship) {
        return this.registeredRelationships.remove(mappedRelationship);
    }

    @Override
    public NodeBuilder visitedNode(Object entity) {
        return this.visitedObjects.get(entity);
    }

    @Override
    public void registerNewObject(Long reference, Object entity) {
        this.createdObjectsWithId.put(reference, entity);
        this.register(entity);
    }

    @Override
    public Object getNewObject(Long id) {
        return this.createdObjectsWithId.get(id);
    }

    @Override
    public void register(Object object) {
        if (!this.log.contains(object)) {
            this.log.add(object);
        }
    }

    @Override
    public void registerTransientRelationship(SrcTargetKey key, Object object) {
        if (!this.log.contains(object)) {
            this.log.add(object);
            Collection collection = this.transientRelsIndex.computeIfAbsent(key, k -> new HashSet());
            collection.add(object);
        }
    }

    @Override
    public Collection<Object> registry() {
        return this.log;
    }

    @Override
    public boolean deregisterOutgoingRelationships(Long src, String relationshipType, Class endNodeType) {
        Mappable mappedRelationship;
        Iterator<Mappable> iterator = this.registeredRelationships.iterator();
        boolean nothingToDelete = true;
        ArrayList<Mappable> cleared = new ArrayList<Mappable>();
        while (iterator.hasNext()) {
            mappedRelationship = iterator.next();
            if (mappedRelationship.getStartNodeId() != src.longValue() || !mappedRelationship.getRelationshipType().equals(relationshipType) || !endNodeType.equals(mappedRelationship.getEndNodeType())) continue;
            cleared.add(mappedRelationship);
            iterator.remove();
            nothingToDelete = false;
        }
        if (nothingToDelete) {
            return true;
        }
        iterator = cleared.iterator();
        while (iterator.hasNext()) {
            mappedRelationship = iterator.next();
            if (this.isMappableAlreadyDeleted(mappedRelationship)) {
                this.registerRelationship(mappedRelationship);
                iterator.remove();
                continue;
            }
            this.deletedRelationships.add(mappedRelationship);
        }
        return cleared.size() > 0;
    }

    @Override
    public boolean deregisterIncomingRelationships(Long tgt, String relationshipType, Class endNodeType, boolean relationshipEntity) {
        Mappable mappedRelationship;
        Iterator<Mappable> iterator = this.registeredRelationships.iterator();
        ArrayList<Mappable> cleared = new ArrayList<Mappable>();
        boolean nothingToDelete = true;
        while (iterator.hasNext()) {
            mappedRelationship = iterator.next();
            if (mappedRelationship.getEndNodeId() != tgt.longValue() || !mappedRelationship.getRelationshipType().equals(relationshipType) || !endNodeType.equals(relationshipEntity ? mappedRelationship.getEndNodeType() : mappedRelationship.getStartNodeType())) continue;
            cleared.add(mappedRelationship);
            iterator.remove();
            nothingToDelete = false;
        }
        if (nothingToDelete) {
            return true;
        }
        iterator = cleared.iterator();
        while (iterator.hasNext()) {
            mappedRelationship = iterator.next();
            if (this.isMappableAlreadyDeleted(mappedRelationship)) {
                this.registerRelationship(mappedRelationship);
                iterator.remove();
                continue;
            }
            this.deletedRelationships.add(mappedRelationship);
        }
        return cleared.size() > 0;
    }

    @Override
    public void visitRelationshipEntity(Long relationshipEntity) {
        this.visitedRelationshipEntities.add(relationshipEntity);
    }

    @Override
    public boolean visitedRelationshipEntity(Long relationshipEntity) {
        return this.visitedRelationshipEntities.contains(relationshipEntity);
    }

    @Override
    public Compiler getCompiler() {
        return this.compiler;
    }

    @Override
    public Long getId(Long reference) {
        if (this.newNodeIds.containsKey(reference)) {
            return this.newNodeIds.get(reference);
        }
        return reference;
    }

    @Override
    public void registerNewId(Long reference, Long id) {
        this.newNodeIds.put(reference, id);
    }

    @Override
    public void deregister(NodeBuilder nodeBuilder) {
        this.compiler.unmap(nodeBuilder);
    }

    @Override
    public Collection<Mappable> getDeletedRelationships() {
        return this.deletedRelationships;
    }

    @Override
    public Object getVisitedObject(Long reference) {
        return this.visitedObjects.get(reference);
    }

    @Override
    public Collection<Object> getTransientRelationships(SrcTargetKey srcTargetKey) {
        Collection<Object> objects = this.transientRelsIndex.get(srcTargetKey);
        if (objects != null) {
            return objects;
        }
        return Collections.emptySet();
    }

    private boolean isMappableAlreadyDeleted(Mappable mappedRelationship) {
        for (Mappable deletedRelationship : this.deletedRelationships) {
            if (deletedRelationship.getEndNodeId() != mappedRelationship.getEndNodeId() || deletedRelationship.getStartNodeId() != mappedRelationship.getStartNodeId() || !deletedRelationship.getRelationshipType().equals(mappedRelationship.getRelationshipType())) continue;
            return true;
        }
        return false;
    }
}

