/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.neo4j.ogm.classloader.MetaDataClassLoader;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.ByteArrayBase64Converter;
import org.neo4j.ogm.typeconversion.ByteArrayWrapperBase64Converter;
import org.neo4j.ogm.typeconversion.DateArrayStringConverter;
import org.neo4j.ogm.typeconversion.DateCollectionStringConverter;
import org.neo4j.ogm.typeconversion.DateStringConverter;
import org.neo4j.ogm.typeconversion.EnumArrayStringConverter;
import org.neo4j.ogm.typeconversion.EnumCollectionStringConverter;
import org.neo4j.ogm.typeconversion.EnumStringConverter;
import org.neo4j.ogm.typeconversion.NumberArrayStringConverter;
import org.neo4j.ogm.typeconversion.NumberCollectionStringConverter;
import org.neo4j.ogm.typeconversion.NumberStringConverter;

public abstract class ConvertibleTypes {
    public static AttributeConverter<?, ?> getDateConverter() {
        return new DateStringConverter("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }

    public static AttributeConverter<?, ?> getDateArrayConverter() {
        return new DateArrayStringConverter("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }

    public static AttributeConverter<?, ?> getDateCollectionConverter(String collectionType) {
        try {
            Class collectionClazz = MetaDataClassLoader.loadClass((String)collectionType);
            return new DateCollectionStringConverter("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", collectionClazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AttributeConverter<?, ?> getEnumConverter(Class enumClass) {
        return new EnumStringConverter(enumClass);
    }

    public static AttributeConverter<?, ?> getEnumArrayConverter(Class enumClass) {
        return new EnumArrayStringConverter(enumClass);
    }

    public static AttributeConverter<?, ?> getEnumCollectionConverter(Class enumClass, String collectionType) {
        try {
            Class collectionClazz = MetaDataClassLoader.loadClass((String)collectionType);
            return new EnumCollectionStringConverter(enumClass, collectionClazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AttributeConverter<?, ?> getBigIntegerConverter() {
        return new NumberStringConverter(BigInteger.class);
    }

    public static AttributeConverter<?, ?> getBigIntegerArrayConverter() {
        return new NumberArrayStringConverter(BigInteger.class);
    }

    public static AttributeConverter<?, ?> getBigIntegerCollectionConverter(String collectionType) {
        try {
            Class collectionClazz = MetaDataClassLoader.loadClass((String)collectionType);
            return new NumberCollectionStringConverter(BigInteger.class, collectionClazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AttributeConverter<?, ?> getBigDecimalConverter() {
        return new NumberStringConverter(BigDecimal.class);
    }

    public static AttributeConverter<?, ?> getBigDecimalArrayConverter() {
        return new NumberArrayStringConverter(BigDecimal.class);
    }

    public static AttributeConverter<?, ?> getBigDecimalCollectionConverter(String collectionType) {
        try {
            Class collectionClazz = MetaDataClassLoader.loadClass((String)collectionType);
            return new NumberCollectionStringConverter(BigDecimal.class, collectionClazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AttributeConverter<?, ?> getByteArrayBase64Converter() {
        return new ByteArrayBase64Converter();
    }

    public static AttributeConverter<?, ?> getByteArrayWrapperBase64Converter() {
        return new ByteArrayWrapperBase64Converter();
    }
}

