/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.compiler.CompileContext;
import org.neo4j.ogm.compiler.Compiler;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.TransientRelationship;
import org.neo4j.ogm.entity.io.EntityAccessManager;
import org.neo4j.ogm.entity.io.FieldWriter;
import org.neo4j.ogm.entity.io.PropertyReader;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.DefaultRequest;
import org.neo4j.ogm.session.request.RowStatementFactory;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestExecutor.class);
    private Neo4jSession session;

    public RequestExecutor(Neo4jSession session) {
        this.session = session;
    }

    public void executeSave(CompileContext context) {
        this.executeSave(context, true);
    }

    public void executeSave(List<CompileContext> contexts) {
        boolean newTransaction = false;
        Transaction tx = this.session.getTransaction();
        if (tx == null) {
            tx = this.session.beginTransaction();
            newTransaction = true;
        }
        for (CompileContext context : contexts) {
            this.executeSave(context, false);
        }
        if (newTransaction) {
            tx.commit();
            tx.close();
        }
    }

    private void registerEntityIds(CompileContext context, Response<RowModel> response, List<ReferenceMapping> entityRefMappings, List<ReferenceMapping> relEntityRefMappings) {
        RowModel rowModel;
        while ((rowModel = (RowModel)response.next()) != null) {
            Object[] results = rowModel.getValues();
            String[] variables = rowModel.variables();
            Long entityRef = null;
            Long entityId = null;
            String type = null;
            for (int i = 0; i < variables.length; ++i) {
                if (variables[i].equals("id")) {
                    entityId = ((Number)results[i]).longValue();
                }
                if (variables[i].equals("ref")) {
                    entityRef = ((Number)results[i]).longValue();
                }
                if (!variables[i].equals("type")) continue;
                type = (String)results[i];
            }
            if (type != null && type.equals("node")) {
                entityRefMappings.add(new ReferenceMapping(entityRef, entityId));
                if (entityRef != null && entityRef.equals(entityId)) {
                    LOGGER.debug("to update: nodeEntity {}:{}", (Object)entityRef, (Object)entityId);
                    continue;
                }
                LOGGER.debug("to create: nodeEntity {}:{}", (Object)entityRef, (Object)entityId);
                context.registerNewId(entityRef, entityId);
                continue;
            }
            if (type == null || !type.equals("rel")) continue;
            relEntityRefMappings.add(new ReferenceMapping(entityRef, entityId));
            if (entityRef != null && entityRef.equals(entityId)) {
                LOGGER.debug("to (maybe) update: relEntity {}:{}", (Object)entityRef, (Object)entityId);
                continue;
            }
            LOGGER.debug("to (maybe) create: relEntity {}:{}", (Object)entityRef, (Object)entityId);
            context.registerNewId(entityRef, entityId);
        }
    }

    private void registerNewRelIds(Response<RowModel> response, List<ReferenceMapping> relRefMappings) {
        RowModel rowModel;
        while ((rowModel = (RowModel)response.next()) != null) {
            Object[] results = rowModel.getValues();
            Long relRef = ((Number)results[0]).longValue();
            Long relId = ((Number)results[1]).longValue();
            relRefMappings.add(new ReferenceMapping(relRef, relId));
        }
    }

    private void updateNodeEntities(CompileContext context, Neo4jSession session, List<ReferenceMapping> entityRefMappings) {
        for (Object obj : context.registry()) {
            PropertyReader idReader;
            Long id;
            ClassInfo classInfo;
            if (obj instanceof TransientRelationship || (classInfo = session.metaData().classInfo(obj)).isRelationshipEntity() || (id = (Long)(idReader = EntityAccessManager.getIdentityPropertyReader(classInfo)).readProperty(obj)) == null) continue;
            LOGGER.debug("updating existing node id: {}, {}", (Object)id, obj);
            RequestExecutor.registerEntity(session.context(), classInfo, id, obj);
        }
        for (ReferenceMapping referenceMapping : entityRefMappings) {
            if (referenceMapping.ref.equals(referenceMapping.id)) continue;
            Object newEntity = context.getNewObject(referenceMapping.ref);
            LOGGER.debug("creating new node id: {}, {}, {}", new Object[]{referenceMapping.ref, referenceMapping.id, newEntity});
            RequestExecutor.initialiseNewEntity(referenceMapping.id, newEntity, session);
        }
    }

    private void updateRelationshipEntities(CompileContext context, Neo4jSession session, List<ReferenceMapping> relationshipEntityRefMappings) {
        for (ReferenceMapping referenceMapping : relationshipEntityRefMappings) {
            if (referenceMapping.ref.equals(referenceMapping.id)) {
                Object existingRelationshipEntity = session.context().getRelationshipEntity(referenceMapping.id);
                if (existingRelationshipEntity == null) continue;
                LOGGER.debug("updating existing relationship entity id: {}", (Object)referenceMapping.id);
                ClassInfo classInfo = session.metaData().classInfo(existingRelationshipEntity);
                RequestExecutor.registerEntity(session.context(), classInfo, referenceMapping.id, existingRelationshipEntity);
                continue;
            }
            Object newRelationshipEntity = context.getNewObject(referenceMapping.ref);
            if (newRelationshipEntity == null) continue;
            LOGGER.debug("creating new relationship entity id: {}", (Object)referenceMapping.id);
            RequestExecutor.initialiseNewEntity(referenceMapping.id, newRelationshipEntity, session);
        }
    }

    private void executeSave(CompileContext context, boolean transactionRequired) {
        Compiler compiler = context.getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        ArrayList<ReferenceMapping> entityReferenceMappings = new ArrayList<ReferenceMapping>();
        ArrayList<ReferenceMapping> relReferenceMappings = new ArrayList<ReferenceMapping>();
        boolean newTransaction = false;
        Transaction tx = this.session.getTransaction();
        if (tx == null && transactionRequired) {
            tx = this.session.beginTransaction();
            newTransaction = true;
        }
        if (compiler.hasStatementsDependentOnNewNodes()) {
            DefaultRequest createNodesRowRequest = new DefaultRequest();
            createNodesRowRequest.setStatements(compiler.createNodesStatements());
            try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)createNodesRowRequest);){
                this.registerEntityIds(context, (Response<RowModel>)response, entityReferenceMappings, relReferenceMappings);
            }
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.addAll(compiler.createRelationshipsStatements());
            statements.addAll(compiler.updateNodesStatements());
            statements.addAll(compiler.updateRelationshipStatements());
            statements.addAll(compiler.deleteRelationshipStatements());
            statements.addAll(compiler.deleteRelationshipEntityStatements());
            DefaultRequest defaultRequest = new DefaultRequest();
            defaultRequest.setStatements(statements);
            try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)defaultRequest);){
                this.registerEntityIds(context, (Response<RowModel>)response, entityReferenceMappings, relReferenceMappings);
                this.registerNewRelIds((Response<RowModel>)response, relReferenceMappings);
            }
        }
        List statements = compiler.getAllStatements();
        if (statements.size() > 0) {
            DefaultRequest defaultRequest = new DefaultRequest();
            defaultRequest.setStatements(statements);
            try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)defaultRequest);){
                this.registerEntityIds(context, (Response<RowModel>)response, entityReferenceMappings, relReferenceMappings);
                this.registerNewRelIds((Response<RowModel>)response, relReferenceMappings);
            }
        }
        if (transactionRequired && newTransaction) {
            tx.commit();
            tx.close();
        }
        this.updateNodeEntities(context, this.session, entityReferenceMappings);
        this.updateRelationshipEntities(context, this.session, relReferenceMappings);
        this.updateRelationships(context, this.session, relReferenceMappings);
    }

    private void updateRelationships(CompileContext context, Neo4jSession session, List<ReferenceMapping> relRefMappings) {
        Map<Long, TransientRelationship> registeredTransientRelationshipIndex = this.buildRegisteredTransientRelationshipIndex(context);
        for (ReferenceMapping referenceMapping : relRefMappings) {
            if (!registeredTransientRelationshipIndex.containsKey(referenceMapping.ref)) continue;
            TransientRelationship transientRelationship = registeredTransientRelationshipIndex.get(referenceMapping.ref);
            MappedRelationship mappedRelationship = new MappedRelationship(context.getId(transientRelationship.getSrc()), transientRelationship.getRel(), context.getId(transientRelationship.getTgt()), transientRelationship.getSrcClass(), transientRelationship.getTgtClass());
            if (session.context().getRelationshipEntity(referenceMapping.id) != null) {
                mappedRelationship.setRelationshipId(referenceMapping.id);
            }
            session.context().addRelationship(mappedRelationship);
        }
    }

    private Map<Long, TransientRelationship> buildRegisteredTransientRelationshipIndex(CompileContext context) {
        HashMap<Long, TransientRelationship> transientRelationshipIndex = new HashMap<Long, TransientRelationship>();
        for (Object obj : context.registry()) {
            if (!TransientRelationship.class.isAssignableFrom(obj.getClass())) continue;
            TransientRelationship transientRelationship = (TransientRelationship)obj;
            transientRelationshipIndex.put(transientRelationship.getRef(), transientRelationship);
        }
        return transientRelationshipIndex;
    }

    private static void initialiseNewEntity(Long identity, Object persisted, Neo4jSession session) {
        MappingContext mappingContext = session.context();
        Transaction tx = session.getTransaction();
        if (persisted != null) {
            ClassInfo classInfo = session.metaData().classInfo(persisted);
            Field identityField = classInfo.getField(classInfo.identityField());
            FieldWriter.write(identityField, persisted, identity);
            if (tx != null) {
                ((AbstractTransaction)tx).registerNew(persisted);
            }
            RequestExecutor.registerEntity(mappingContext, classInfo, identity, persisted);
        }
    }

    private static void registerEntity(MappingContext mappingContext, ClassInfo classInfo, Long identity, Object entity) {
        if (classInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity") == null) {
            mappingContext.replaceNodeEntity(entity, identity);
        } else {
            mappingContext.replaceRelationshipEntity(entity, identity);
        }
    }

    class ReferenceMapping {
        private Long ref;
        private Long id;

        ReferenceMapping(Long ref, Long id) {
            this.ref = ref;
            this.id = id;
        }
    }
}

