/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.entity.io;

import java.lang.reflect.Method;
import org.neo4j.ogm.entity.io.EntityAccess;
import org.neo4j.ogm.entity.io.EntityAccessException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.session.Utils;

public class MethodWriter
extends EntityAccess {
    private final MethodInfo setterMethodInfo;
    private final Class<?> parameterType;
    private final Method method;

    MethodWriter(ClassInfo classInfo, MethodInfo methodInfo) {
        this.setterMethodInfo = methodInfo;
        this.method = classInfo.getMethod(this.setterMethodInfo);
        this.parameterType = this.method.getParameterTypes()[0];
    }

    private static void write(Method method, Object instance, Object value) {
        try {
            method.invoke(instance, value);
        }
        catch (IllegalArgumentException iae) {
            throw new EntityAccessException("Failed to invoke method '" + method.getName() + "'. Expected argument type: " + method.getParameterTypes()[0] + " actual argument type: " + value.getClass(), iae);
        }
        catch (Exception e) {
            throw new EntityAccessException("Failed to invoke method '" + method.getName() + "'", e);
        }
    }

    public static Object read(Method method, Object instance) {
        try {
            return method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(Object instance, Object value) {
        if (this.setterMethodInfo.hasPropertyConverter()) {
            value = this.setterMethodInfo.getPropertyConverter().toEntityAttribute(value);
            MethodWriter.write(this.method, instance, value);
        } else {
            if (this.setterMethodInfo.isScalar() && (value != null && value.getClass() != this.parameterType || value == null)) {
                value = Utils.coerceTypes(this.parameterType, value);
            }
            MethodWriter.write(this.method, instance, value);
        }
    }

    @Override
    public Class<?> type() {
        if (this.setterMethodInfo.hasPropertyConverter()) {
            try {
                for (Method method : this.setterMethodInfo.getPropertyConverter().getClass().getDeclaredMethods()) {
                    if (!method.getName().equals("toGraphProperty") || method.isSynthetic()) continue;
                    return method.getReturnType();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.parameterType;
    }

    @Override
    public String relationshipName() {
        return this.setterMethodInfo.relationship();
    }

    @Override
    public String relationshipDirection() {
        return this.setterMethodInfo.relationshipDirection("UNDIRECTED");
    }

    @Override
    public boolean forScalar() {
        return !Iterable.class.isAssignableFrom(this.type()) && !this.type().isArray();
    }

    @Override
    public String typeParameterDescriptor() {
        return this.setterMethodInfo.getTypeDescriptor();
    }
}

