/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.classloader.MetaDataClassLoader;
import org.neo4j.ogm.context.EntityMemo;
import org.neo4j.ogm.context.LabelHistory;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.register.EntityRegister;
import org.neo4j.ogm.context.register.LabelHistoryRegister;
import org.neo4j.ogm.context.register.TypeRegister;
import org.neo4j.ogm.entity.io.EntityAccessManager;
import org.neo4j.ogm.entity.io.FieldReader;
import org.neo4j.ogm.entity.io.FieldWriter;
import org.neo4j.ogm.entity.io.PropertyReader;
import org.neo4j.ogm.entity.io.RelationalReader;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;

public class MappingContext {
    private final TypeRegister typeRegister;
    private final EntityRegister<Long> nodeEntityRegister;
    private final EntityRegister<Object> primaryIndexNodeRegister;
    private final EntityRegister<Long> relationshipEntityRegister;
    private final Set<MappedRelationship> relationshipRegister;
    private final LabelHistoryRegister labelHistoryRegister;
    private final EntityMemo objectMemo;
    private final MetaData metaData;

    public MappingContext(MetaData metaData) {
        this.metaData = metaData;
        this.objectMemo = new EntityMemo(metaData);
        this.typeRegister = new TypeRegister();
        this.nodeEntityRegister = new EntityRegister();
        this.primaryIndexNodeRegister = new EntityRegister();
        this.relationshipEntityRegister = new EntityRegister();
        this.relationshipRegister = new CopyOnWriteArraySet<MappedRelationship>();
        this.labelHistoryRegister = new LabelHistoryRegister();
    }

    public Object getNodeEntity(Object id) {
        Object result = null;
        if (id instanceof Long) {
            result = this.nodeEntityRegister.get((Long)id);
        }
        if (result == null) {
            result = this.primaryIndexNodeRegister.get(id);
        }
        return result;
    }

    public Object addNodeEntity(Object entity, Long id) {
        if (this.nodeEntityRegister.add(id, entity)) {
            entity = this.nodeEntityRegister.get(id);
            this.addType(entity.getClass(), entity, id);
            this.remember(entity);
            this.collectLabelHistory(entity);
            ClassInfo primaryIndexClassInfo = this.metaData.classInfo(entity);
            FieldInfo primaryIndexField = primaryIndexClassInfo.primaryIndexField();
            if (primaryIndexField != null) {
                Object primaryIndexValue = new FieldReader(primaryIndexClassInfo, primaryIndexField).read(entity);
                this.primaryIndexNodeRegister.add(primaryIndexValue, entity);
            }
        }
        return entity;
    }

    public boolean removeRelationship(MappedRelationship mappedRelationship) {
        return this.relationshipRegister.remove(mappedRelationship);
    }

    public void removeNodeEntity(Object entity, Long id) {
        this.removeType(entity.getClass(), id);
        this.nodeEntityRegister.remove(id);
        ClassInfo primaryIndexClassInfo = this.metaData.classInfo(entity);
        FieldInfo primaryIndexField = primaryIndexClassInfo.primaryIndexField();
        if (primaryIndexField != null) {
            Object primaryIndexValue = new FieldReader(primaryIndexClassInfo, primaryIndexField).read(entity);
            this.primaryIndexNodeRegister.remove(primaryIndexValue);
        }
        this.deregisterDependentRelationshipEntity(entity);
    }

    public void replaceNodeEntity(Object entity, Long id) {
        this.nodeEntityRegister.remove(id);
        ClassInfo primaryIndexClassInfo = this.metaData.classInfo(entity);
        FieldInfo primaryIndexField = primaryIndexClassInfo.primaryIndexField();
        if (primaryIndexField != null) {
            Object primaryIndexValue = new FieldReader(primaryIndexClassInfo, primaryIndexField).read(entity);
            this.primaryIndexNodeRegister.remove(primaryIndexValue);
        }
        this.addNodeEntity(entity, id);
    }

    public void replaceRelationshipEntity(Object entity, Long id) {
        this.relationshipEntityRegister.remove(id);
        this.addRelationshipEntity(entity, id);
    }

    public Collection<Object> getEntities(Class<?> type) {
        return this.typeRegister.get(type).values();
    }

    public LabelHistory labelHistory(Long identity) {
        return this.labelHistoryRegister.get(identity);
    }

    public boolean isDirty(Object entity) {
        ClassInfo classInfo = this.metaData.classInfo(entity);
        Object id = EntityAccessManager.getIdentityPropertyReader(classInfo).readProperty(entity);
        return !this.objectMemo.remembered((Long)id, entity, classInfo);
    }

    public boolean containsRelationship(MappedRelationship relationship) {
        return this.relationshipRegister.contains(relationship);
    }

    public Set<MappedRelationship> getRelationships() {
        return this.relationshipRegister;
    }

    public void addRelationship(MappedRelationship relationship) {
        if (relationship.getRelationshipId() != null && this.relationshipEntityRegister.get(relationship.getRelationshipId()) == null) {
            relationship.setRelationshipId(null);
        }
        this.relationshipRegister.add(relationship);
    }

    public void clear() {
        this.objectMemo.clear();
        this.relationshipRegister.clear();
        this.nodeEntityRegister.clear();
        this.primaryIndexNodeRegister.clear();
        this.typeRegister.clear();
        this.relationshipEntityRegister.clear();
        this.labelHistoryRegister.clear();
    }

    public Object getRelationshipEntity(Long relationshipId) {
        return this.relationshipEntityRegister.get(relationshipId);
    }

    public Object addRelationshipEntity(Object relationshipEntity, Long id) {
        if (this.relationshipEntityRegister.add(id, relationshipEntity)) {
            relationshipEntity = this.relationshipEntityRegister.get(id);
            this.addType(relationshipEntity.getClass(), relationshipEntity, id);
            this.remember(relationshipEntity);
        }
        return relationshipEntity;
    }

    public void removeType(Class<?> type) {
        ClassInfo classInfo = this.metaData.classInfo(type.getName());
        if (classInfo.isInterface()) {
            List<ClassInfo> implementingClasses = this.metaData.getImplementingClassInfos(classInfo.name());
            for (ClassInfo implementingClass : implementingClasses) {
                try {
                    String implementingClassName = implementingClass.name();
                    this.removeType(MetaDataClassLoader.loadClass((String)implementingClassName));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            PropertyReader identityReader = EntityAccessManager.getIdentityPropertyReader(classInfo);
            this.removeType(type, identityReader);
        }
    }

    public boolean detachNodeEntity(Object id) {
        Object objectToDetach = this.getNodeEntity(id);
        if (objectToDetach != null) {
            this.removeEntity(objectToDetach);
            return true;
        }
        return false;
    }

    public boolean detachRelationshipEntity(Long id) {
        Object objectToDetach = this.relationshipEntityRegister.get(id);
        if (objectToDetach != null) {
            this.removeEntity(objectToDetach);
            return true;
        }
        return false;
    }

    public void removeEntity(Object entity) {
        Class<?> type = entity.getClass();
        ClassInfo classInfo = this.metaData.classInfo(type.getName());
        PropertyReader identityReader = EntityAccessManager.getIdentityPropertyReader(classInfo);
        Long id = (Long)identityReader.readProperty(entity);
        this.purge(entity, identityReader, type);
        if (id != null) {
            this.typeRegister.remove(this.metaData, type, id);
        }
    }

    public void reset(Object entity) {
        this.removeEntity(entity);
        Class<?> type = entity.getClass();
        ClassInfo classInfo = this.metaData.classInfo(type.getName());
        Field identityField = classInfo.getField(classInfo.identityField());
        FieldWriter.write(identityField, entity, null);
    }

    public Set<Object> neighbours(Object entity) {
        HashSet<Object> neighbours = new HashSet<Object>();
        Class<?> type = entity.getClass();
        ClassInfo classInfo = this.metaData.classInfo(type.getName());
        PropertyReader identityReader = EntityAccessManager.getIdentityPropertyReader(classInfo);
        Long id = (Long)identityReader.readProperty(entity);
        if (id != null) {
            if (!this.metaData.isRelationshipEntity(type.getName())) {
                if (this.nodeEntityRegister.contains(id)) {
                    for (MappedRelationship mappedRelationship : this.relationshipRegister) {
                        Object affectedObject;
                        if (mappedRelationship.getStartNodeId() != id.longValue() && mappedRelationship.getEndNodeId() != id.longValue() || (affectedObject = mappedRelationship.getEndNodeId() == id.longValue() ? this.nodeEntityRegister.get(mappedRelationship.getStartNodeId()) : this.nodeEntityRegister.get(mappedRelationship.getEndNodeId())) == null) continue;
                        neighbours.add(affectedObject);
                    }
                }
            } else if (this.relationshipEntityRegister.contains(id)) {
                RelationalReader startNodeReader = EntityAccessManager.getStartNodeReader(classInfo);
                RelationalReader endNodeReader = EntityAccessManager.getEndNodeReader(classInfo);
                neighbours.add(startNodeReader.read(entity));
                neighbours.add(endNodeReader.read(entity));
            }
        }
        return neighbours;
    }

    private void deregisterDependentRelationshipEntity(Object startOrEndEntity) {
        Iterator<Long> relationshipEntityIdIterator = this.relationshipEntityRegister.iterator();
        while (relationshipEntityIdIterator.hasNext()) {
            Long relationshipEntityId = relationshipEntityIdIterator.next();
            Object relationshipEntity = this.relationshipEntityRegister.get(relationshipEntityId);
            RelationalReader startNodeReader = EntityAccessManager.getStartNodeReader(this.metaData.classInfo(relationshipEntity));
            RelationalReader endNodeReader = EntityAccessManager.getEndNodeReader(this.metaData.classInfo(relationshipEntity));
            if (startOrEndEntity != startNodeReader.read(relationshipEntity) && startOrEndEntity != endNodeReader.read(relationshipEntity)) continue;
            relationshipEntityIdIterator.remove();
        }
    }

    private void removeType(Class<?> type, PropertyReader identityReader) {
        for (Object entity : this.getEntities(type)) {
            this.purge(entity, identityReader, type);
        }
        this.typeRegister.delete(type);
    }

    private void purge(Object entity, PropertyReader identityReader, Class type) {
        Long id = (Long)identityReader.readProperty(entity);
        if (id != null) {
            if (!this.metaData.isRelationshipEntity(type.getName())) {
                if (this.nodeEntityRegister.contains(id)) {
                    this.nodeEntityRegister.remove(id);
                    for (MappedRelationship mappedRelationship : this.relationshipRegister) {
                        Object relEntity;
                        if (mappedRelationship.getStartNodeId() != id.longValue() && mappedRelationship.getEndNodeId() != id.longValue()) continue;
                        if (mappedRelationship.getRelationshipId() != null && (relEntity = this.relationshipEntityRegister.get(mappedRelationship.getRelationshipId())) != null) {
                            ClassInfo relClassInfo = this.metaData.classInfo(relEntity);
                            PropertyReader relIdentityReader = EntityAccessManager.getIdentityPropertyReader(relClassInfo);
                            this.purge(relEntity, relIdentityReader, relClassInfo.getUnderlyingClass());
                        }
                        this.relationshipRegister.remove(mappedRelationship);
                    }
                }
            } else if (this.relationshipEntityRegister.contains(id)) {
                this.relationshipEntityRegister.remove(id);
                RelationalReader startNodeReader = EntityAccessManager.getStartNodeReader(this.metaData.classInfo(entity));
                Object startNode = startNodeReader.read(entity);
                this.removeEntity(startNode);
                RelationalReader endNodeReader = EntityAccessManager.getEndNodeReader(this.metaData.classInfo(entity));
                Object endNode = endNodeReader.read(entity);
                this.removeEntity(endNode);
            }
        }
    }

    private void addType(Class type, Object entity, Object id) {
        this.typeRegister.add(this.metaData, type, entity, id);
    }

    private void removeType(Class type, Object id) {
        this.typeRegister.remove(this.metaData, type, id);
    }

    private void remember(Object entity) {
        ClassInfo classInfo = this.metaData.classInfo(entity);
        Long id = (Long)EntityAccessManager.getIdentityPropertyReader(classInfo).readProperty(entity);
        this.objectMemo.remember(id, entity, classInfo);
    }

    private void collectLabelHistory(Object entity) {
        ClassInfo classInfo = this.metaData.classInfo(entity);
        FieldInfo fieldInfo = classInfo.labelFieldOrNull();
        if (fieldInfo != null) {
            FieldReader reader = new FieldReader(classInfo, fieldInfo);
            Collection labels = (Collection)reader.read(entity);
            Long id = (Long)EntityAccessManager.getIdentityPropertyReader(classInfo).readProperty(entity);
            this.labelHistory(id).push(labels);
        }
    }
}

