/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.entity.io.FieldWriter;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;

class EntityMemo {
    private static final long SEED = -197749L;
    private final Map<Long, Long> nodeHash = new HashMap<Long, Long>();
    private final Map<Long, Long> relEntityHash = new HashMap<Long, Long>();
    private final MetaData metaData;

    EntityMemo(MetaData metaData) {
        this.metaData = metaData;
    }

    public void remember(Long entityId, Object object, ClassInfo classInfo) {
        if (this.metaData.isRelationshipEntity(classInfo.name())) {
            this.relEntityHash.put(entityId, EntityMemo.hash(object, classInfo));
        } else {
            this.nodeHash.put(entityId, EntityMemo.hash(object, classInfo));
        }
    }

    boolean remembered(Long entityId, Object object, ClassInfo classInfo) {
        boolean isRelEntity = false;
        if (entityId != null) {
            if (this.metaData.isRelationshipEntity(classInfo.name())) {
                isRelEntity = true;
            }
            if (!isRelEntity && !this.nodeHash.containsKey(entityId) || isRelEntity && !this.relEntityHash.containsKey(entityId)) {
                return false;
            }
            long actual = EntityMemo.hash(object, classInfo);
            long expected = isRelEntity ? this.relEntityHash.get(entityId) : this.nodeHash.get(entityId);
            return actual == expected;
        }
        return false;
    }

    void clear() {
        this.nodeHash.clear();
        this.relEntityHash.clear();
    }

    private static long hash(Object object, ClassInfo classInfo) {
        long hash = -197749L;
        ArrayList<FieldInfo> hashFields = new ArrayList<FieldInfo>(classInfo.propertyFields());
        if (classInfo.labelFieldOrNull() != null) {
            hashFields.add(classInfo.labelFieldOrNull());
        }
        for (FieldInfo fieldInfo : hashFields) {
            Field field = classInfo.getField(fieldInfo);
            Object value = FieldWriter.read(field, object);
            if (value == null) continue;
            if (value.getClass().isArray()) {
                hash = hash * 31L + (long)Arrays.hashCode(EntityMemo.convertToObjectArray(value));
                continue;
            }
            if (value instanceof Iterable) {
                hash = hash * 31L + (long)value.hashCode();
                continue;
            }
            hash = hash * 31L + EntityMemo.hash(value.toString());
        }
        return hash;
    }

    private static long hash(String string) {
        long h = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            h = 31L * h + (long)string.charAt(i);
        }
        return h;
    }

    private static Object[] convertToObjectArray(Object array) {
        int len = Array.getLength(array);
        Object[] out = new Object[len];
        for (int i = 0; i < len; ++i) {
            out[i] = Array.get(array, i);
        }
        return Arrays.asList(out).toArray();
    }
}

