/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.autoindex;

import java.util.Collections;
import java.util.Map;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.session.request.RowDataStatement;

class AutoIndex {
    private static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    private final String description;

    public AutoIndex(String label, String property, boolean unique) {
        this.description = unique ? "CONSTRAINT ON ( " + label.toLowerCase() + ":" + label + " ) ASSERT " + label.toLowerCase() + "." + property + " IS UNIQUE" : "INDEX ON :" + label + "( " + property + " )";
    }

    public Statement getCreateStatement() {
        return new RowDataStatement("CREATE " + this.description, EMPTY_MAP);
    }

    public Statement getDropStatement() {
        return new RowDataStatement("DROP " + this.description, EMPTY_MAP);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoIndex autoIndex = (AutoIndex)o;
        return this.description != null ? this.description.equals(autoIndex.description) : autoIndex.description == null;
    }

    public int hashCode() {
        return this.description != null ? this.description.hashCode() : 0;
    }
}

