/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.utils;

import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.entity.io.EntityAccessManager;
import org.neo4j.ogm.entity.io.FieldReader;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;

public class EntityUtils {
    public static Long identity(Object entity, MetaData metaData) {
        ClassInfo classInfo = metaData.classInfo(entity);
        Object id = EntityAccessManager.getIdentityPropertyReader(classInfo).readProperty(entity);
        return id == null ? (long)(-System.identityHashCode(entity)) : (Long)id;
    }

    public static Collection<String> labels(Object entity, MetaData metaData) {
        ClassInfo classInfo = metaData.classInfo(entity);
        Collection<String> staticLabels = classInfo.staticLabels();
        FieldInfo labelFieldInfo = classInfo.labelFieldOrNull();
        if (labelFieldInfo != null) {
            FieldReader reader = new FieldReader(classInfo, labelFieldInfo);
            Collection labels = (Collection)reader.readProperty(entity);
            return CollectionUtils.union(staticLabels, (Iterable)labels);
        }
        return staticLabels;
    }
}

