/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ConstantPool;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;

public class FieldsInfo {
    private static final int STATIC_FIELD = 8;
    private static final int FINAL_FIELD = 16;
    private static final int TRANSIENT_FIELD = 128;
    private final Map<String, FieldInfo> fields = new HashMap<String, FieldInfo>();

    FieldsInfo() {
    }

    public FieldsInfo(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int fieldCount = dataInputStream.readUnsignedShort();
        for (int i = 0; i < fieldCount; ++i) {
            int accessFlags = dataInputStream.readUnsignedShort();
            String fieldName = constantPool.readString(dataInputStream.readUnsignedShort());
            String descriptor = constantPool.readString(dataInputStream.readUnsignedShort());
            int attributesCount = dataInputStream.readUnsignedShort();
            ObjectAnnotations objectAnnotations = new ObjectAnnotations();
            String typeParameterDescriptor = null;
            for (int j = 0; j < attributesCount; ++j) {
                String attributeName = constantPool.readString(dataInputStream.readUnsignedShort());
                int attributeLength = dataInputStream.readInt();
                if ("RuntimeVisibleAnnotations".equals(attributeName)) {
                    int annotationCount = dataInputStream.readUnsignedShort();
                    for (int m = 0; m < annotationCount; ++m) {
                        AnnotationInfo info = new AnnotationInfo(dataInputStream, constantPool);
                        objectAnnotations.put(info.getName(), info);
                    }
                    continue;
                }
                if ("Signature".equals(attributeName)) {
                    String signature = constantPool.readString(dataInputStream.readUnsignedShort());
                    if (!signature.contains("<")) continue;
                    typeParameterDescriptor = signature.substring(signature.indexOf(60) + 1, signature.indexOf(62));
                    continue;
                }
                dataInputStream.skipBytes(attributeLength);
            }
            if ((accessFlags & 0x98) != 0 || objectAnnotations.get("org.neo4j.ogm.annotation.Transient") != null) continue;
            this.fields.put(fieldName, new FieldInfo(fieldName, descriptor, typeParameterDescriptor, objectAnnotations));
        }
    }

    public Collection<FieldInfo> fields() {
        return this.fields.values();
    }

    public Collection<FieldInfo> compositeFields() {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        for (FieldInfo field : this.fields()) {
            if (!field.hasCompositeConverter()) continue;
            fields.add(field);
        }
        return Collections.unmodifiableList(fields);
    }

    public FieldInfo get(String name) {
        return this.fields.get(name);
    }

    public void append(FieldsInfo fieldsInfo) {
        for (FieldInfo fieldInfo : fieldsInfo.fields()) {
            if (this.fields.containsKey(fieldInfo.getName())) continue;
            this.fields.put(fieldInfo.getName(), fieldInfo);
        }
    }
}

