/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import org.neo4j.ogm.entity.io.EntityAccessManager;
import org.neo4j.ogm.exception.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;

public class GraphIdDelegate
implements Capability.GraphId {
    private final Neo4jSession session;

    public GraphIdDelegate(Neo4jSession session) {
        this.session = session;
    }

    @Override
    public Long resolveGraphIdFor(Object possibleEntity) {
        if (possibleEntity != null) {
            ClassInfo classInfo = this.session.metaData().classInfo(possibleEntity);
            try {
                Object id;
                if (classInfo != null && (id = EntityAccessManager.getIdentityPropertyReader(classInfo).readProperty(possibleEntity)) != null) {
                    return (long)((Long)id);
                }
            }
            catch (MappingException me) {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean detachNodeEntity(Long id) {
        return this.session.context().detachNodeEntity(id);
    }

    @Override
    public boolean detachRelationshipEntity(Long id) {
        return this.session.context().detachRelationshipEntity(id);
    }
}

