/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.util.Collection;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.DefaultGraphModelRequest;
import org.neo4j.ogm.cypher.query.DefaultGraphRowListModelRequest;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.session.request.FilteredQuery;
import org.neo4j.ogm.session.request.FilteredQueryBuilder;
import org.neo4j.ogm.session.request.strategy.QueryStatements;

public class NodeQueryStatements
implements QueryStatements {
    private String primaryIndex;

    public NodeQueryStatements() {
    }

    public NodeQueryStatements(String primaryIndex) {
        this.primaryIndex = primaryIndex;
    }

    @Override
    public PagingAndSortingQuery findOne(Object id, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findOne(id, this.primaryIndex);
        }
        if (max > 0) {
            String qry = this.primaryIndex != null ? String.format("MATCH (n) WHERE n." + this.primaryIndex + " = { id } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", min, max) : String.format("MATCH (n) WHERE ID(n) = { id } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", min, max);
            return new DefaultGraphModelRequest(qry, Utils.map("id", id));
        }
        return DepthZeroReadStrategy.findOne(id, this.primaryIndex);
    }

    @Override
    public PagingAndSortingQuery findAll(Collection<Long> ids, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findAll(ids);
        }
        if (max > 0) {
            String qry = String.format("MATCH (n) WHERE ID(n) IN { ids } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", min, max);
            return new DefaultGraphModelRequest(qry, Utils.map("ids", ids));
        }
        return DepthZeroReadStrategy.findAll(ids);
    }

    @Override
    public PagingAndSortingQuery findAllByType(String label, Collection<Long> ids, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findAllByLabel(label, ids);
        }
        if (max > 0) {
            String qry = String.format("MATCH (n:`%s`) WHERE ID(n) IN { ids } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", label, min, max);
            return new DefaultGraphModelRequest(qry, Utils.map("ids", ids));
        }
        return DepthZeroReadStrategy.findAllByLabel(label, ids);
    }

    @Override
    public PagingAndSortingQuery findAll() {
        return new DefaultGraphModelRequest("MATCH p=()-->() RETURN p", Utils.map(new Object[0]));
    }

    @Override
    public PagingAndSortingQuery findByType(String label, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findByLabel(label);
        }
        if (max > 0) {
            String qry = String.format("MATCH (n:`%s`) WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", label, min, max);
            return new DefaultGraphModelRequest(qry, Utils.map(new Object[0]));
        }
        return DepthZeroReadStrategy.findByLabel(label);
    }

    @Override
    public PagingAndSortingQuery findByType(String label, Filters parameters, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findByProperties(label, parameters);
        }
        if (max > 0) {
            FilteredQuery query = FilteredQueryBuilder.buildNodeQuery(label, parameters);
            query.setReturnClause(String.format("WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p, ID(n)", min, max));
            return new DefaultGraphRowListModelRequest(query.statement(), query.parameters());
        }
        return DepthZeroReadStrategy.findByProperties(label, parameters);
    }

    private int min(int depth) {
        return Math.min(0, depth);
    }

    private int max(int depth) {
        return Math.max(0, depth);
    }

    private static class InfiniteDepthReadStrategy {
        private InfiniteDepthReadStrategy() {
        }

        public static DefaultGraphModelRequest findOne(Object id, String primaryIndex) {
            if (primaryIndex != null) {
                return new DefaultGraphModelRequest("MATCH (n) WHERE n." + primaryIndex + " = { id } WITH n MATCH p=(n)-[*0..]-(m) RETURN p", Utils.map("id", id));
            }
            return new DefaultGraphModelRequest("MATCH (n) WHERE ID(n) = { id } WITH n MATCH p=(n)-[*0..]-(m) RETURN p", Utils.map("id", id));
        }

        public static DefaultGraphModelRequest findAll(Collection<Long> ids) {
            return new DefaultGraphModelRequest("MATCH (n) WHERE ID(n) IN { ids } WITH n MATCH p=(n)-[*0..]-(m) RETURN p", Utils.map("ids", ids));
        }

        public static DefaultGraphModelRequest findAllByLabel(String label, Collection<Long> ids) {
            return new DefaultGraphModelRequest(String.format("MATCH (n:`%s`) WHERE ID(n) IN { ids } WITH n MATCH p=(n)-[*0..]-(m) RETURN p", label), Utils.map("ids", ids));
        }

        public static DefaultGraphModelRequest findByLabel(String label) {
            return new DefaultGraphModelRequest(String.format("MATCH (n:`%s`) WITH n MATCH p=(n)-[*0..]-(m) RETURN p", label), Utils.map(new Object[0]));
        }

        public static DefaultGraphRowListModelRequest findByProperties(String label, Filters parameters) {
            FilteredQuery query = FilteredQueryBuilder.buildNodeQuery(label, parameters);
            query.setReturnClause(" WITH n MATCH p=(n)-[*0..]-(m) RETURN p, ID(n)");
            return new DefaultGraphRowListModelRequest(query.statement(), query.parameters());
        }
    }

    private static class DepthZeroReadStrategy {
        private DepthZeroReadStrategy() {
        }

        public static DefaultGraphModelRequest findOne(Object id, String primaryIndex) {
            if (primaryIndex != null) {
                return new DefaultGraphModelRequest("MATCH (n) WHERE n." + primaryIndex + " = { id } RETURN n", Utils.map("id", id));
            }
            return new DefaultGraphModelRequest("MATCH (n) WHERE ID(n) = { id } RETURN n", Utils.map("id", id));
        }

        public static DefaultGraphModelRequest findAll(Collection<Long> ids) {
            return new DefaultGraphModelRequest("MATCH (n) WHERE ID(n) IN { ids } RETURN n", Utils.map("ids", ids));
        }

        public static DefaultGraphModelRequest findAllByLabel(String label, Collection<Long> ids) {
            return new DefaultGraphModelRequest(String.format("MATCH (n:`%s`) WHERE ID(n) IN { ids } RETURN n", label), Utils.map("ids", ids));
        }

        public static DefaultGraphModelRequest findByLabel(String label) {
            return new DefaultGraphModelRequest(String.format("MATCH (n:`%s`) RETURN n", label), Utils.map(new Object[0]));
        }

        public static DefaultGraphModelRequest findByProperties(String label, Filters parameters) {
            FilteredQuery query = FilteredQueryBuilder.buildNodeQuery(label, parameters);
            query.setReturnClause("RETURN n");
            return new DefaultGraphModelRequest(query.statement(), query.parameters());
        }
    }
}

