/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.DataInputStream;
import java.io.IOException;

class ConstantPool {
    private final Object[] pool;

    public ConstantPool(DataInputStream stream) throws IOException {
        int size = stream.readUnsignedShort();
        this.pool = new Object[size];
        block12: for (int i = 1; i < size; ++i) {
            int flag = stream.readUnsignedByte();
            switch (flag) {
                case 1: {
                    this.pool[i] = stream.readUTF();
                    continue block12;
                }
                case 3: {
                    this.pool[i] = stream.readInt();
                    continue block12;
                }
                case 4: {
                    this.pool[i] = Float.valueOf(stream.readFloat());
                    continue block12;
                }
                case 5: {
                    this.pool[i] = stream.readLong();
                    ++i;
                    continue block12;
                }
                case 6: {
                    this.pool[i] = stream.readDouble();
                    ++i;
                    continue block12;
                }
                case 7: 
                case 8: {
                    this.pool[i] = stream.readUnsignedShort();
                    continue block12;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    stream.skipBytes(2);
                    this.pool[i] = stream.readUnsignedShort();
                    continue block12;
                }
                case 15: {
                    stream.skipBytes(3);
                    continue block12;
                }
                case 16: {
                    stream.skipBytes(2);
                    continue block12;
                }
                case 18: {
                    stream.skipBytes(4);
                    continue block12;
                }
                default: {
                    throw new ClassFormatError("Unknown tag value for constant pool entry: " + flag);
                }
            }
        }
    }

    public String lookup(int entry) {
        Object constantPoolObj = this.pool[entry];
        if (constantPoolObj instanceof Integer) {
            return String.valueOf(this.pool[(Integer)constantPoolObj]);
        }
        throw new RuntimeException("Not expected here!");
    }

    public Boolean readBoolean(int entry) {
        return (Integer)this.pool[entry] == 1;
    }

    public Byte readByte(int entry) {
        return new Byte(String.valueOf(this.pool[entry]));
    }

    public Character readChar(int entry) {
        return Character.valueOf(Character.forDigit((Integer)this.pool[entry], 10));
    }

    public Double readDouble(int entry) {
        return (Double)this.pool[entry];
    }

    public Float readFloat(int entry) {
        return (Float)this.pool[entry];
    }

    public Integer readInteger(int entry) {
        return (Integer)this.pool[entry];
    }

    public Long readLong(int entry) {
        return (Long)this.pool[entry];
    }

    public Short readShort(int entry) {
        return Short.decode(String.valueOf(this.pool[entry]));
    }

    public String readString(int entry) {
        return (String)this.pool[entry];
    }
}

