/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.entity.io;

import java.util.Map;
import org.neo4j.ogm.entity.io.MethodWriter;
import org.neo4j.ogm.entity.io.PropertyReader;
import org.neo4j.ogm.entity.io.RelationalReader;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;

public class MethodReader
implements RelationalReader,
PropertyReader {
    private final ClassInfo classInfo;
    private final MethodInfo methodInfo;

    MethodReader(ClassInfo classInfo, MethodInfo methodInfo) {
        this.classInfo = classInfo;
        this.methodInfo = methodInfo;
    }

    @Override
    public Object read(Object instance) {
        return MethodWriter.read(this.classInfo.getMethod(this.methodInfo), instance);
    }

    @Override
    public Object readProperty(Object instance) {
        if (this.methodInfo.hasCompositeConverter()) {
            throw new IllegalStateException("The readComposite method should be used for fields with a CompositeAttributeConverter");
        }
        Object value = MethodWriter.read(this.classInfo.getMethod(this.methodInfo), instance);
        if (this.methodInfo.hasPropertyConverter()) {
            value = this.methodInfo.getPropertyConverter().toGraphProperty(value);
        }
        return value;
    }

    @Override
    public Map<String, ?> readComposite(Object instance) {
        if (!this.methodInfo.hasCompositeConverter()) {
            throw new IllegalStateException("readComposite should only be used when a field is annotated with a CompositeAttributeConverter");
        }
        Object value = MethodWriter.read(this.classInfo.getMethod(this.methodInfo), instance);
        return this.methodInfo.getCompositeConverter().toGraphProperties(value);
    }

    @Override
    public String relationshipType() {
        return this.methodInfo.relationship();
    }

    @Override
    public String relationshipDirection() {
        AnnotationInfo relationshipAnnotation;
        ObjectAnnotations annotations = this.methodInfo.getAnnotations();
        if (annotations != null && (relationshipAnnotation = annotations.get("org.neo4j.ogm.annotation.Relationship")) != null) {
            return relationshipAnnotation.get("direction", "UNDIRECTED");
        }
        return "UNDIRECTED";
    }

    @Override
    public boolean isComposite() {
        return this.methodInfo.hasCompositeConverter();
    }

    @Override
    public String typeDescriptor() {
        return this.methodInfo.getTypeDescriptor();
    }

    @Override
    public String propertyName() {
        return this.methodInfo.property();
    }
}

