/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.util.Collection;
import java.util.HashSet;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.strategy.QueryStatements;

public class LoadByIdsDelegate
implements Capability.LoadByIds {
    private final Neo4jSession session;

    public LoadByIdsDelegate(Neo4jSession session) {
        this.session = session;
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder, Pagination pagination, int depth) {
        String entityType = this.session.entityType(type.getName());
        QueryStatements queryStatements = this.session.queryStatementsFor(type);
        PagingAndSortingQuery qry = queryStatements.findAllByType(entityType, ids, depth).setSortOrder(sortOrder).setPagination(pagination);
        try (Response response = this.session.requestHandler().execute((GraphModelRequest)qry);){
            new GraphEntityMapper(this.session.metaData(), this.session.context()).map(type, (Response<GraphModel>)response);
            Collection<T> collection = this.lookup(type, ids);
            return collection;
        }
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids) {
        return this.loadAll(type, ids, new SortOrder(), null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, int depth) {
        return this.loadAll(type, ids, new SortOrder(), null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder) {
        return this.loadAll(type, ids, sortOrder, null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder, int depth) {
        return this.loadAll(type, ids, sortOrder, null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, Pagination paging) {
        return this.loadAll(type, ids, new SortOrder(), paging, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, Pagination paging, int depth) {
        return this.loadAll(type, ids, new SortOrder(), paging, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(type, ids, sortOrder, pagination, 1);
    }

    private <T> Collection<T> lookup(Class<T> type, Collection<Long> ids) {
        HashSet<T> results = new HashSet<T>();
        ClassInfo typeInfo = this.session.metaData().classInfo(type.getName());
        for (Long id : ids) {
            Object ref = typeInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity") == null ? this.session.context().getNodeEntity(id) : this.session.context().getRelationshipEntity(id);
            try {
                results.add(type.cast(ref));
            }
            catch (ClassCastException classCastException) {}
        }
        return results;
    }
}

