/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.autoindex.AutoIndexManager;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.service.Components;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;

public class SessionFactory {
    private final MetaData metaData;
    private final AutoIndexManager autoIndexManager;

    public SessionFactory(String ... packages) {
        this.metaData = new MetaData(packages);
        this.autoIndexManager = new AutoIndexManager(this.metaData, Components.driver());
        this.autoIndexManager.build();
    }

    public SessionFactory(Class ... classes) {
        this.metaData = new MetaData(classes);
        this.autoIndexManager = new AutoIndexManager(this.metaData, Components.driver());
        this.autoIndexManager.build();
    }

    public SessionFactory(Configuration configuration, String ... packages) {
        Components.configure((Configuration)configuration);
        this.metaData = new MetaData(packages);
        this.autoIndexManager = new AutoIndexManager(this.metaData, Components.driver());
        this.autoIndexManager.build();
    }

    public SessionFactory(Configuration configuration, Class ... classes) {
        Components.configure((Configuration)configuration);
        this.metaData = new MetaData(classes);
        this.autoIndexManager = new AutoIndexManager(this.metaData, Components.driver());
        this.autoIndexManager.build();
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public Session openSession() {
        return new Neo4jSession(this.metaData, Components.driver());
    }

    public void close() {
    }
}

