/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.utils;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.classloader.ClassLoaderResolver;
import org.neo4j.ogm.classloader.MetaDataClassLoader;
import org.neo4j.ogm.service.ResourceService;

public abstract class ClassUtils {
    private static Map<String, Class<?>> descriptorTypeMappings = new HashMap();
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_MAP = new HashMap<String, Class<?>>(){
        {
            this.put("Z", Boolean.TYPE);
            this.put("B", Byte.TYPE);
            this.put("C", Character.TYPE);
            this.put("D", Double.TYPE);
            this.put("F", Float.TYPE);
            this.put("I", Integer.TYPE);
            this.put("J", Long.TYPE);
            this.put("S", Short.TYPE);
        }
    };

    public static Class<?> getType(String descriptor) {
        if (descriptorTypeMappings.containsKey(descriptor)) {
            return descriptorTypeMappings.get(descriptor);
        }
        Class<?> type = ClassUtils.computeType(descriptor);
        descriptorTypeMappings.put(descriptor, type);
        return type;
    }

    public static Class<?> getTypeOrNull(String descriptor) {
        Class<?> type;
        if (descriptorTypeMappings.containsKey(descriptor)) {
            return descriptorTypeMappings.get(descriptor);
        }
        try {
            type = ClassUtils.computeType(descriptor);
        }
        catch (Exception e) {
            return null;
        }
        descriptorTypeMappings.put(descriptor, type);
        return type;
    }

    private static Class<?> computeType(String descriptor) {
        String typeName;
        if (descriptor.startsWith("+") || descriptor.startsWith("-") || descriptor.contains(":")) {
            throw new RuntimeException("The use of wild cards in generic return types of method parameters is not supported");
        }
        if (descriptor.contains(":")) {
            return ClassUtils.getType(descriptor.substring(descriptor.indexOf(":") + 1));
        }
        if (descriptor.startsWith("()")) {
            return ClassUtils.getType(descriptor.substring(2));
        }
        int p = descriptor.indexOf("(");
        int q = descriptor.indexOf(")");
        if (!descriptor.contains("[")) {
            if (descriptor.endsWith(";)V")) {
                --q;
            }
            if (descriptor.startsWith("(L")) {
                ++p;
            }
            if (descriptor.startsWith("L")) {
                ++p;
                q = descriptor.length() - 1;
            }
        }
        if (descriptor.startsWith("[")) {
            p = 0;
            q = 2;
        }
        if (descriptor.startsWith("[L")) {
            p = 1;
            q = descriptor.length() - 1;
        }
        if (descriptor.length() == 1) {
            q = 1;
        }
        if (q == p + 1) {
            p = q + 1;
            q = descriptor.length() - 1;
        }
        if ((typeName = descriptor.substring(p + 1, q).replace("/", ".")).length() == 1) {
            return PRIMITIVE_TYPE_MAP.get(typeName);
        }
        if (typeName.contains("<T")) {
            typeName = typeName.substring(0, typeName.indexOf("<T"));
        }
        if (typeName.contains("<L")) {
            typeName = typeName.substring(0, typeName.indexOf("<L"));
        }
        try {
            return MetaDataClassLoader.loadClass((String)typeName);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<File> getUniqueClasspathElements(List<String> classPaths) {
        HashSet<File> pathFiles = new HashSet<File>();
        for (String classPath : classPaths) {
            try {
                Enumeration<URL> resources = ClassLoaderResolver.resolve().getResources(classPath.replace(".", "/"));
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    pathFiles.add(ResourceService.resolve((URL)url));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return pathFiles;
    }
}

