/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.entity.io.EntityAccessManager;
import org.neo4j.ogm.entity.io.RelationalReader;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.event.Event;
import org.neo4j.ogm.session.event.PersistenceEvent;
import org.neo4j.ogm.utils.ClassUtils;
import org.neo4j.ogm.utils.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SaveEventDelegate {
    private static final Logger logger = LoggerFactory.getLogger(SaveEventDelegate.class);
    private Neo4jSession session;
    private Set<Long> visited;
    private Set<Object> preSaved;
    private Set<MappedRelationship> registeredRelationships = new HashSet<MappedRelationship>();
    private Set<MappedRelationship> addedRelationships = new HashSet<MappedRelationship>();
    private Set<MappedRelationship> deletedRelationships = new HashSet<MappedRelationship>();

    public SaveEventDelegate(Neo4jSession session) {
        this.session = session;
        this.preSaved = new HashSet<Object>();
        this.visited = new HashSet<Long>();
        this.registeredRelationships.clear();
        this.registeredRelationships.addAll(session.context().getRelationships());
    }

    public void preSave(Object object) {
        if (Collection.class.isAssignableFrom(object.getClass())) {
            for (Object element : (Collection)object) {
                this.preSaveCheck(element);
            }
        } else if (object.getClass().isArray()) {
            for (Object element : Collections.singletonList(object)) {
                this.preSaveCheck(element);
            }
        } else {
            this.preSaveCheck(object);
        }
    }

    public void postSave() {
        for (Object object : this.preSaved) {
            this.fire(Event.TYPE.POST_SAVE, object);
        }
    }

    private void preSaveCheck(Object object) {
        if (this.visit(object)) {
            logger.debug("visiting: {}", object);
            for (Object child : this.children(object)) {
                this.preSaveCheck(child);
            }
            if (!this.preSaveFired(object) && this.dirty(object)) {
                this.firePreSave(object);
            }
        } else {
            logger.debug("already visited: {}", object);
        }
        for (Object other : this.unreachable()) {
            if (!this.visit(other) || this.preSaveFired(other)) continue;
            this.firePreSave(other);
        }
        for (Object other : this.touched()) {
            if (this.preSaveFired(other)) continue;
            this.firePreSave(other);
        }
    }

    private void firePreSave(Object object) {
        this.fire(Event.TYPE.PRE_SAVE, object);
        this.preSaved.add(object);
    }

    private void fire(Event.TYPE eventType, Object object) {
        this.session.notifyListeners(new PersistenceEvent(object, eventType));
    }

    private boolean preSaveFired(Object object) {
        return this.preSaved.contains(object);
    }

    private Set<Object> touched() {
        HashSet<Object> touched = new HashSet<Object>();
        for (MappedRelationship added : this.addedRelationships) {
            Object src = this.session.context().getNodeEntity(added.getStartNodeId());
            Object tgt = this.session.context().getNodeEntity(added.getEndNodeId());
            if (src != null) {
                touched.add(src);
            }
            if (tgt == null) continue;
            touched.add(tgt);
        }
        return touched;
    }

    private Set<Object> unreachable() {
        HashSet<Object> unreachable = new HashSet<Object>();
        for (MappedRelationship mappedRelationship : this.deletedRelationships) {
            unreachable.add(this.session.context().getNodeEntity(mappedRelationship.getStartNodeId()));
            unreachable.add(this.session.context().getNodeEntity(mappedRelationship.getEndNodeId()));
        }
        return unreachable;
    }

    private boolean visit(Object object) {
        return this.visited.add(EntityUtils.identity(object, this.session.metaData()));
    }

    private boolean dirty(Object parent) {
        if (this.session.context().isDirty(parent)) {
            logger.debug("dirty: {}", parent);
            return true;
        }
        ClassInfo parentClassInfo = this.session.metaData().classInfo(parent);
        if (!parentClassInfo.isRelationshipEntity()) {
            for (RelationalReader reader : this.relationalReaders(parent)) {
                this.clearPreviousRelationships(parent, reader);
                for (MappedRelationship mappable : this.map(parent, reader)) {
                    if (this.isNew(mappable)) {
                        logger.debug("added new relationship: {} to {}", (Object)mappable, parent);
                        this.addedRelationships.add(mappable);
                        return true;
                    }
                    this.registeredRelationships.add(mappable);
                    this.deletedRelationships.remove(mappable);
                }
            }
            for (MappedRelationship previous : this.session.context().getRelationships()) {
                if (!this.isDeleted(previous)) continue;
                logger.debug("deleted: {} from {}", (Object)previous, parent);
                return true;
            }
        }
        return false;
    }

    private boolean isNew(MappedRelationship mappedRelationship) {
        return !this.session.context().getRelationships().contains(mappedRelationship);
    }

    private boolean isDeleted(MappedRelationship mappedRelationship) {
        return !this.registeredRelationships.contains(mappedRelationship);
    }

    private void clearPreviousRelationships(Object parent, RelationalReader reader) {
        Long id = EntityUtils.identity(parent, this.session.metaData());
        String type = reader.relationshipType();
        Class<?> endNodeType = ClassUtils.getType(reader.typeParameterDescriptor());
        if (reader.relationshipDirection().equals("INCOMING")) {
            this.deregisterIncomingRelationship(id, type, endNodeType);
        } else if (reader.relationshipDirection().equals("OUTGOING")) {
            this.deregisterOutgoingRelationship(id, type, endNodeType);
        } else {
            this.deregisterOutgoingRelationship(id, type, endNodeType);
            this.deregisterIncomingRelationship(id, type, endNodeType);
        }
    }

    private void deregisterIncomingRelationship(Long id, String relationshipType, Class endNodeType) {
        Iterator<MappedRelationship> iterator = this.registeredRelationships.iterator();
        while (iterator.hasNext()) {
            MappedRelationship mappedRelationship = iterator.next();
            if (mappedRelationship.getEndNodeId() != id.longValue() || !mappedRelationship.getRelationshipType().equals(relationshipType) || !endNodeType.equals(mappedRelationship.getStartNodeType())) continue;
            this.deletedRelationships.add(mappedRelationship);
            iterator.remove();
        }
    }

    private void deregisterOutgoingRelationship(Long id, String relationshipType, Class endNodeType) {
        Iterator<MappedRelationship> iterator = this.registeredRelationships.iterator();
        while (iterator.hasNext()) {
            MappedRelationship mappedRelationship = iterator.next();
            if (mappedRelationship.getStartNodeId() != id.longValue() || !mappedRelationship.getRelationshipType().equals(relationshipType) || !endNodeType.equals(mappedRelationship.getEndNodeType())) continue;
            this.deletedRelationships.add(mappedRelationship);
            iterator.remove();
        }
    }

    private List<Object> children(Object parent) {
        ArrayList<Object> children = new ArrayList<Object>();
        ClassInfo parentClassInfo = this.session.metaData().classInfo(parent);
        if (parentClassInfo != null) {
            for (RelationalReader reader : EntityAccessManager.getRelationalReaders(parentClassInfo)) {
                Object reference = reader.read(parent);
                if (reference == null) continue;
                if (reference.getClass().isArray()) {
                    this.addChildren(children, Collections.singletonList(reference));
                    continue;
                }
                if (Collection.class.isAssignableFrom(reference.getClass())) {
                    this.addChildren(children, (Collection)reference);
                    continue;
                }
                this.addChild(children, reference);
            }
        }
        return children;
    }

    private void addChildren(Collection children, Collection references) {
        for (Object reference : references) {
            this.addChild(children, reference);
        }
    }

    private void addChild(Collection children, Object reference) {
        children.add(reference);
    }

    private Collection<RelationalReader> relationalReaders(Object object) {
        return EntityAccessManager.getRelationalReaders(this.session.metaData().classInfo(object));
    }

    private Collection<MappedRelationship> map(Object parent, RelationalReader reader) {
        HashSet<MappedRelationship> mappedRelationships = new HashSet<MappedRelationship>();
        Object reference = reader.read(parent);
        if (reference != null) {
            if (reference.getClass().isArray()) {
                this.mapCollection(mappedRelationships, parent, reader, Collections.singletonList(reference));
            } else if (Collection.class.isAssignableFrom(reference.getClass())) {
                this.mapCollection(mappedRelationships, parent, reader, (Collection)reference);
            } else {
                this.mapInstance(mappedRelationships, parent, reader, reference);
            }
        }
        return mappedRelationships;
    }

    private void mapInstance(Set<MappedRelationship> mappedRelationships, Object parent, RelationalReader reader, Object reference) {
        String type = reader.relationshipType();
        String direction = reader.relationshipDirection();
        ClassInfo parentInfo = this.session.metaData().classInfo(parent);
        Long parentId = EntityUtils.identity(parent, this.session.metaData());
        ClassInfo referenceInfo = this.session.metaData().classInfo(reference);
        if (referenceInfo != null) {
            Long referenceId = EntityUtils.identity(reference, this.session.metaData());
            if (!referenceInfo.isRelationshipEntity()) {
                if (direction.equals("OUTGOING")) {
                    MappedRelationship edge = new MappedRelationship(parentId, type, referenceId, parentInfo.getUnderlyingClass(), referenceInfo.getUnderlyingClass());
                    mappedRelationships.add(edge);
                } else {
                    MappedRelationship edge = new MappedRelationship(referenceId, type, parentId, referenceInfo.getUnderlyingClass(), parentInfo.getUnderlyingClass());
                    mappedRelationships.add(edge);
                }
            } else {
                Object startNode = EntityAccessManager.getStartNodeReader(referenceInfo).read(reference);
                ClassInfo startNodeInfo = this.session.metaData().classInfo(startNode);
                Long startNodeId = EntityUtils.identity(startNode, this.session.metaData());
                Object endNode = EntityAccessManager.getEndNodeReader(referenceInfo).read(reference);
                ClassInfo endNodeInfo = this.session.metaData().classInfo(endNode);
                Long endNodeId = EntityUtils.identity(endNode, this.session.metaData());
                MappedRelationship edge = new MappedRelationship(startNodeId, type, endNodeId, referenceId, startNodeInfo.getUnderlyingClass(), endNodeInfo.getUnderlyingClass());
                mappedRelationships.add(edge);
            }
        }
    }

    private void mapCollection(Set<MappedRelationship> mappedRelationships, Object parent, RelationalReader reader, Collection references) {
        for (Object reference : references) {
            this.mapInstance(mappedRelationships, parent, reader, reference);
        }
    }
}

