/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.session.GraphCallback;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.delegates.DeleteDelegate;
import org.neo4j.ogm.session.delegates.ExecuteQueriesDelegate;
import org.neo4j.ogm.session.delegates.GraphIdDelegate;
import org.neo4j.ogm.session.delegates.LoadByIdsDelegate;
import org.neo4j.ogm.session.delegates.LoadByInstancesDelegate;
import org.neo4j.ogm.session.delegates.LoadByTypeDelegate;
import org.neo4j.ogm.session.delegates.LoadOneDelegate;
import org.neo4j.ogm.session.delegates.SaveDelegate;
import org.neo4j.ogm.session.delegates.TransactionsDelegate;
import org.neo4j.ogm.session.event.Event;
import org.neo4j.ogm.session.event.EventListener;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.session.request.strategy.VariableDepthQuery;
import org.neo4j.ogm.session.request.strategy.VariableDepthRelationshipQuery;
import org.neo4j.ogm.session.transaction.DefaultTransactionManager;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jSession
implements Session {
    private final Logger logger = LoggerFactory.getLogger(Neo4jSession.class);
    private final MetaData metaData;
    private final MappingContext mappingContext;
    private final DefaultTransactionManager txManager;
    private final LoadOneDelegate loadOneHandler = new LoadOneDelegate(this);
    private final LoadByTypeDelegate loadByTypeHandler = new LoadByTypeDelegate(this);
    private final LoadByIdsDelegate loadByIdsHandler = new LoadByIdsDelegate(this);
    private final LoadByInstancesDelegate loadByInstancesDelegate = new LoadByInstancesDelegate(this);
    private final SaveDelegate saveDelegate = new SaveDelegate(this);
    private final DeleteDelegate deleteDelegate = new DeleteDelegate(this);
    private final ExecuteQueriesDelegate executeQueriesDelegate = new ExecuteQueriesDelegate(this);
    private final TransactionsDelegate transactionsDelegate = new TransactionsDelegate(this);
    private final GraphIdDelegate graphIdDelegate = new GraphIdDelegate(this);
    private Driver driver;
    private List<EventListener> registeredEventListeners = new LinkedList<EventListener>();

    public Neo4jSession(MetaData metaData, Driver driver) {
        this.metaData = metaData;
        this.driver = driver;
        this.mappingContext = new MappingContext(metaData);
        this.txManager = new DefaultTransactionManager(this, driver);
    }

    @Override
    public EventListener register(EventListener eventListener) {
        this.registeredEventListeners.add(eventListener);
        return eventListener;
    }

    @Override
    public void notifyListeners(Event event) {
        block6: for (EventListener eventListener : this.registeredEventListeners) {
            if (eventListener == null) {
                this.registeredEventListeners.remove(eventListener);
                continue;
            }
            switch (event.getLifeCycle()) {
                case PRE_SAVE: {
                    eventListener.onPreSave(event);
                    continue block6;
                }
                case POST_SAVE: {
                    eventListener.onPostSave(event);
                    continue block6;
                }
                case PRE_DELETE: {
                    eventListener.onPreDelete(event);
                    continue block6;
                }
                case POST_DELETE: {
                    eventListener.onPostDelete(event);
                    continue block6;
                }
            }
            this.logger.warn("Event not recognised: {}", (Object)event);
        }
    }

    @Override
    public boolean eventsEnabled() {
        return this.registeredEventListeners.size() > 0;
    }

    @Override
    public boolean dispose(EventListener eventListener) {
        for (EventListener next : this.registeredEventListeners) {
            if (eventListener != next) continue;
            this.registeredEventListeners.remove(eventListener);
            return true;
        }
        return false;
    }

    @Override
    public <T> T load(Class<T> type, Long id) {
        return this.loadOneHandler.load(type, id);
    }

    @Override
    public <T> T load(Class<T> type, Long id, int depth) {
        return this.loadOneHandler.load(type, id, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type) {
        return this.loadByTypeHandler.loadAll(type);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, int depth) {
        return this.loadByTypeHandler.loadAll(type, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Pagination paging) {
        return this.loadByTypeHandler.loadAll(type, paging);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Pagination paging, int depth) {
        return this.loadByTypeHandler.loadAll(type, paging, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder) {
        return this.loadByTypeHandler.loadAll(type, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, int depth) {
        return this.loadByTypeHandler.loadAll(type, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter) {
        return this.loadByTypeHandler.loadAll(type, filter);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, int depth) {
        return this.loadByTypeHandler.loadAll(type, filter, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder) {
        return this.loadByTypeHandler.loadAll(type, filter, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, int depth) {
        return this.loadByTypeHandler.loadAll(type, filter, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, filter, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, filter, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, filter, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, filter, sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters) {
        return this.loadByTypeHandler.loadAll(type, filters);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, int depth) {
        return this.loadByTypeHandler.loadAll(type, filters, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder) {
        return this.loadByTypeHandler.loadAll(type, filters, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, int depth) {
        return this.loadByTypeHandler.loadAll(type, filters, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, filters, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, filters, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, filters, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, filters, sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids) {
        return this.loadByIdsHandler.loadAll(type, ids);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, int depth) {
        return this.loadByIdsHandler.loadAll(type, ids, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder) {
        return this.loadByIdsHandler.loadAll(type, ids, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder, int depth) {
        return this.loadByIdsHandler.loadAll(type, ids, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, Pagination paging) {
        return this.loadByIdsHandler.loadAll(type, ids, paging);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, Pagination paging, int depth) {
        return this.loadByIdsHandler.loadAll(type, ids, paging, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder, Pagination pagination) {
        return this.loadByIdsHandler.loadAll(type, ids, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByIdsHandler.loadAll(type, ids, sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects) {
        return this.loadByInstancesDelegate.loadAll(objects, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, int depth) {
        return this.loadByInstancesDelegate.loadAll(objects, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder) {
        return this.loadByInstancesDelegate.loadAll(objects, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, int depth) {
        return this.loadByInstancesDelegate.loadAll(objects, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, Pagination pagination) {
        return this.loadByInstancesDelegate.loadAll(objects, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, Pagination pagination, int depth) {
        return this.loadByInstancesDelegate.loadAll(objects, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, Pagination pagination) {
        return this.loadByInstancesDelegate.loadAll(objects, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByInstancesDelegate.loadAll(objects, sortOrder, pagination, depth);
    }

    @Override
    public <T> T queryForObject(Class<T> type, String cypher, Map<String, ?> parameters) {
        return this.executeQueriesDelegate.queryForObject(type, cypher, parameters);
    }

    @Override
    public Result query(String cypher, Map<String, ?> parameters) {
        return this.executeQueriesDelegate.query(cypher, parameters);
    }

    @Override
    public Result query(String cypher, Map<String, ?> parameters, boolean readOnly) {
        return this.executeQueriesDelegate.query(cypher, parameters, readOnly);
    }

    @Override
    public <T> Iterable<T> query(Class<T> type, String cypher, Map<String, ?> parameters) {
        return this.executeQueriesDelegate.query(type, cypher, parameters);
    }

    @Override
    public long countEntitiesOfType(Class<?> entity) {
        return this.executeQueriesDelegate.countEntitiesOfType(entity);
    }

    @Override
    public void purgeDatabase() {
        this.deleteDelegate.purgeDatabase();
    }

    @Override
    public void clear() {
        this.deleteDelegate.clear();
    }

    @Override
    public <T> void delete(T object) {
        this.deleteDelegate.delete(object);
    }

    @Override
    public <T> void deleteAll(Class<T> type) {
        this.deleteDelegate.deleteAll(type);
    }

    @Override
    public <T> void save(T object) {
        this.saveDelegate.save(object);
    }

    @Override
    public <T> void save(T object, int depth) {
        this.saveDelegate.save(object, depth);
    }

    @Override
    public Transaction beginTransaction() {
        return this.transactionsDelegate.beginTransaction();
    }

    @Override
    public Transaction beginTransaction(Transaction.Type type) {
        return this.transactionsDelegate.beginTransaction(type);
    }

    @Override
    @Deprecated
    public <T> T doInTransaction(GraphCallback<T> graphCallback) {
        return this.transactionsDelegate.doInTransaction(graphCallback);
    }

    @Override
    public Transaction getTransaction() {
        return this.transactionsDelegate.getTransaction();
    }

    @Override
    public Long resolveGraphIdFor(Object possibleEntity) {
        return this.graphIdDelegate.resolveGraphIdFor(possibleEntity);
    }

    @Override
    public boolean detachNodeEntity(Long id) {
        return this.graphIdDelegate.detachNodeEntity(id);
    }

    @Override
    public boolean detachRelationshipEntity(Long id) {
        return this.graphIdDelegate.detachRelationshipEntity(id);
    }

    public QueryStatements queryStatementsFor(Class type) {
        if (this.metaData.isRelationshipEntity(type.getName())) {
            return new VariableDepthRelationshipQuery();
        }
        return new VariableDepthQuery();
    }

    public String entityType(String name) {
        return this.metaData.entityType(name);
    }

    public MappingContext context() {
        return this.mappingContext;
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    public Request requestHandler() {
        return this.driver.request();
    }

    public DefaultTransactionManager transactionManager() {
        return this.txManager;
    }

    public void info(String msg) {
        this.logger.info("Thread {}: {}", (Object)Thread.currentThread().getId(), (Object)msg);
    }

    public void warn(String msg) {
        this.logger.warn("Thread {}: {}", (Object)Thread.currentThread().getId(), (Object)msg);
    }

    public void debug(String msg) {
        this.logger.debug("Thread {}: {}", (Object)Thread.currentThread().getId(), (Object)msg);
    }
}

