/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import org.neo4j.ogm.exception.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MethodInfo;

public class ClassValidator {
    private ClassInfo classInfo;

    public ClassValidator(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public void validate() throws MappingException {
        this.validateRelationshipEntity();
        this.validateMethods();
    }

    private void validateRelationshipEntity() throws MappingException {
        if (this.classInfo.isRelationshipEntity() && this.classInfo.labelFieldOrNull() != null) {
            throw new MappingException(String.format("'%s' is a relationship entity. The @Labels annotation can't be applied to relationship entities.", this.classInfo.name()));
        }
    }

    private void validateMethods() {
        for (MethodInfo methodInfo : this.classInfo.propertyGettersAndSetters()) {
            if (!methodInfo.hasAnnotation("org.neo4j.ogm.annotation.Labels")) continue;
            throw new MappingException(String.format("'%s' has the @Labels annotation applied to method '%s'. The @Labels annotation can only be applied to a field.", this.classInfo.name(), methodInfo.getName()));
        }
    }
}

