/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.entity.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.context.DirectedRelationship;
import org.neo4j.ogm.context.DirectedRelationshipForType;
import org.neo4j.ogm.entity.io.EntityAccess;
import org.neo4j.ogm.entity.io.FieldReader;
import org.neo4j.ogm.entity.io.FieldWriter;
import org.neo4j.ogm.entity.io.MethodReader;
import org.neo4j.ogm.entity.io.MethodWriter;
import org.neo4j.ogm.entity.io.PropertyReader;
import org.neo4j.ogm.entity.io.RelationalReader;
import org.neo4j.ogm.entity.io.RelationalWriter;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityAccessManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityAccessManager.class);
    private static Map<ClassInfo, Map<DirectedRelationship, RelationalReader>> relationalReaderCache = new HashMap<ClassInfo, Map<DirectedRelationship, RelationalReader>>();
    private static Map<ClassInfo, Map<DirectedRelationshipForType, RelationalWriter>> relationalWriterCache = new HashMap<ClassInfo, Map<DirectedRelationshipForType, RelationalWriter>>();
    private static Map<ClassInfo, Map<DirectedRelationshipForType, RelationalWriter>> iterableWriterCache = new HashMap<ClassInfo, Map<DirectedRelationshipForType, RelationalWriter>>();
    private static Map<ClassInfo, Map<DirectedRelationshipForType, RelationalReader>> iterableReaderCache = new HashMap<ClassInfo, Map<DirectedRelationshipForType, RelationalReader>>();
    private static Map<ClassInfo, Map<Class, RelationalWriter>> relationshipEntityWriterCache = new HashMap<ClassInfo, Map<Class, RelationalWriter>>();
    private static Map<ClassInfo, Map<String, EntityAccess>> propertyWriterCache = new HashMap<ClassInfo, Map<String, EntityAccess>>();
    private static Map<ClassInfo, Map<String, PropertyReader>> propertyReaderCache = new HashMap<ClassInfo, Map<String, PropertyReader>>();
    private static Map<ClassInfo, Collection<PropertyReader>> propertyReaders = new HashMap<ClassInfo, Collection<PropertyReader>>();
    private static Map<ClassInfo, PropertyReader> identityPropertyReaderCache = new HashMap<ClassInfo, PropertyReader>();
    private static Map<ClassInfo, Collection<RelationalReader>> relationalReaders = new HashMap<ClassInfo, Collection<RelationalReader>>();
    private static final boolean STRICT_MODE = true;
    private static final boolean INFERRED_MODE = false;

    public static EntityAccess getPropertyWriter(final ClassInfo classInfo, String propertyName) {
        if (!propertyWriterCache.containsKey(classInfo)) {
            propertyWriterCache.put(classInfo, new HashMap());
        }
        if (propertyWriterCache.get(classInfo).containsKey(propertyName)) {
            return propertyWriterCache.get(classInfo).get(propertyName);
        }
        MethodInfo setterInfo = classInfo.propertySetter(propertyName);
        EntityAccess propertyWriter = EntityAccessManager.determinePropertyAccessor(classInfo, propertyName, setterInfo, new AccessorFactory<EntityAccess>(){

            @Override
            public EntityAccess makeMethodAccessor(MethodInfo methodInfo) {
                return new MethodWriter(classInfo, methodInfo);
            }

            @Override
            public EntityAccess makeFieldAccessor(FieldInfo fieldInfo) {
                return new FieldWriter(classInfo, fieldInfo);
            }
        });
        propertyWriterCache.get(classInfo).put(propertyName, propertyWriter);
        return propertyWriter;
    }

    public static PropertyReader getPropertyReader(final ClassInfo classInfo, String propertyName) {
        if (!propertyReaderCache.containsKey(classInfo)) {
            propertyReaderCache.put(classInfo, new HashMap());
        }
        if (propertyReaderCache.get(classInfo).containsKey(propertyName)) {
            return propertyReaderCache.get(classInfo).get(propertyName);
        }
        MethodInfo getterInfo = classInfo.propertyGetter(propertyName);
        PropertyReader propertyReader = EntityAccessManager.determinePropertyAccessor(classInfo, propertyName, getterInfo, new AccessorFactory<PropertyReader>(){

            @Override
            public PropertyReader makeMethodAccessor(MethodInfo methodInfo) {
                return new MethodReader(classInfo, methodInfo);
            }

            @Override
            public PropertyReader makeFieldAccessor(FieldInfo fieldInfo) {
                return new FieldReader(classInfo, fieldInfo);
            }
        });
        propertyReaderCache.get(classInfo).put(propertyName, propertyReader);
        return propertyReader;
    }

    private static <T> T determinePropertyAccessor(ClassInfo classInfo, String propertyName, MethodInfo accessorMethodInfo, AccessorFactory<T> factory) {
        if (accessorMethodInfo != null) {
            FieldInfo fieldInfo;
            if (!accessorMethodInfo.hasAnnotation("org.neo4j.ogm.annotation.Property") && (fieldInfo = classInfo.propertyField(propertyName)) != null && !fieldInfo.getAnnotations().isEmpty()) {
                return factory.makeFieldAccessor(fieldInfo);
            }
            return factory.makeMethodAccessor(accessorMethodInfo);
        }
        FieldInfo labelField = classInfo.labelFieldOrNull();
        if (labelField != null && labelField.getName().equals(propertyName)) {
            return factory.makeFieldAccessor(labelField);
        }
        FieldInfo fieldInfo = classInfo.propertyField(propertyName);
        if (fieldInfo != null) {
            return factory.makeFieldAccessor(fieldInfo);
        }
        return null;
    }

    public static RelationalWriter getRelationalWriter(ClassInfo classInfo, String relationshipType, String relationshipDirection, Object scalarValue) {
        if (!relationalWriterCache.containsKey(classInfo)) {
            relationalWriterCache.put(classInfo, new HashMap());
        }
        DirectedRelationshipForType directedRelationship = new DirectedRelationshipForType(relationshipType, relationshipDirection, scalarValue.getClass());
        if (relationalWriterCache.get(classInfo).containsKey(directedRelationship)) {
            return relationalWriterCache.get(classInfo).get(directedRelationship);
        }
        for (MethodInfo methodInfo : classInfo.candidateRelationshipSetters(relationshipType, relationshipDirection, true)) {
            if (methodInfo == null || methodInfo.getAnnotations().isEmpty() || !methodInfo.isTypeOf(scalarValue.getClass()) && !methodInfo.isParameterisedTypeOf(scalarValue.getClass()) && !methodInfo.isArrayOf(scalarValue.getClass())) continue;
            MethodWriter methodWriter = new MethodWriter(classInfo, methodInfo);
            relationalWriterCache.get(classInfo).put(directedRelationship, methodWriter);
            return methodWriter;
        }
        for (FieldInfo fieldInfo : classInfo.candidateRelationshipFields(relationshipType, relationshipDirection, true)) {
            if (fieldInfo == null || fieldInfo.getAnnotations().isEmpty() || !fieldInfo.isTypeOf(scalarValue.getClass()) && !fieldInfo.isParameterisedTypeOf(scalarValue.getClass()) && !fieldInfo.isArrayOf(scalarValue.getClass())) continue;
            FieldWriter fieldWriter = new FieldWriter(classInfo, fieldInfo);
            relationalWriterCache.get(classInfo).put(directedRelationship, fieldWriter);
            return fieldWriter;
        }
        if (!relationshipDirection.equals("INCOMING")) {
            FieldInfo candidateFieldInfo;
            MethodInfo candidateMethodInfo;
            for (MethodInfo methodInfo : classInfo.candidateRelationshipSetters(relationshipType, relationshipDirection, false)) {
                if (methodInfo == null || methodInfo.getAnnotations().isEmpty() || !methodInfo.isTypeOf(scalarValue.getClass()) && !methodInfo.isParameterisedTypeOf(scalarValue.getClass()) && !methodInfo.isArrayOf(scalarValue.getClass())) continue;
                MethodWriter methodWriter = new MethodWriter(classInfo, methodInfo);
                relationalWriterCache.get(classInfo).put(directedRelationship, methodWriter);
                return methodWriter;
            }
            for (FieldInfo fieldInfo : classInfo.candidateRelationshipFields(relationshipType, relationshipDirection, false)) {
                if (fieldInfo == null || fieldInfo.getAnnotations().isEmpty() || !fieldInfo.isTypeOf(scalarValue.getClass()) && !fieldInfo.isParameterisedTypeOf(scalarValue.getClass()) && !fieldInfo.isArrayOf(scalarValue.getClass())) continue;
                FieldWriter fieldWriter = new FieldWriter(classInfo, fieldInfo);
                relationalWriterCache.get(classInfo).put(directedRelationship, fieldWriter);
                return fieldWriter;
            }
            for (MethodInfo methodInfo : classInfo.candidateRelationshipSetters(relationshipType, relationshipDirection, false)) {
                if (methodInfo == null || !methodInfo.isTypeOf(scalarValue.getClass()) && !methodInfo.isParameterisedTypeOf(scalarValue.getClass()) && !methodInfo.isArrayOf(scalarValue.getClass())) continue;
                MethodWriter methodWriter = new MethodWriter(classInfo, methodInfo);
                relationalWriterCache.get(classInfo).put(directedRelationship, methodWriter);
                return methodWriter;
            }
            for (FieldInfo fieldInfo : classInfo.candidateRelationshipFields(relationshipType, relationshipDirection, false)) {
                if (fieldInfo == null || !fieldInfo.isTypeOf(scalarValue.getClass()) && !fieldInfo.isParameterisedTypeOf(scalarValue.getClass()) && !fieldInfo.isArrayOf(scalarValue.getClass())) continue;
                FieldWriter fieldWriter = new FieldWriter(classInfo, fieldInfo);
                relationalWriterCache.get(classInfo).put(directedRelationship, fieldWriter);
                return fieldWriter;
            }
            List<MethodInfo> methodInfos = classInfo.findSetters(scalarValue.getClass());
            if (methodInfos.size() == 1 && !(candidateMethodInfo = methodInfos.iterator().next()).relationshipDirection("UNDIRECTED").equals("INCOMING")) {
                MethodWriter methodWriter = new MethodWriter(classInfo, candidateMethodInfo);
                relationalWriterCache.get(classInfo).put(directedRelationship, methodWriter);
                return methodWriter;
            }
            List<FieldInfo> fieldInfos = classInfo.findFields(scalarValue.getClass());
            if (fieldInfos.size() == 1 && !(candidateFieldInfo = fieldInfos.iterator().next()).relationshipDirection("UNDIRECTED").equals("INCOMING")) {
                FieldWriter fieldWriter = new FieldWriter(classInfo, candidateFieldInfo);
                relationalWriterCache.get(classInfo).put(directedRelationship, fieldWriter);
                return fieldWriter;
            }
        }
        relationalWriterCache.get(classInfo).put(directedRelationship, null);
        return null;
    }

    public static RelationalReader getRelationalReader(ClassInfo classInfo, String relationshipType, String relationshipDirection) {
        if (!relationalReaderCache.containsKey(classInfo)) {
            relationalReaderCache.put(classInfo, new HashMap());
        }
        DirectedRelationship directedRelationship = new DirectedRelationship(relationshipType, relationshipDirection);
        if (relationalReaderCache.get(classInfo).containsKey(directedRelationship)) {
            return relationalReaderCache.get(classInfo).get(directedRelationship);
        }
        MethodInfo methodInfo = classInfo.relationshipGetter(relationshipType, relationshipDirection, true);
        if (methodInfo != null && !methodInfo.getAnnotations().isEmpty()) {
            MethodReader methodReader = new MethodReader(classInfo, methodInfo);
            relationalReaderCache.get(classInfo).put(directedRelationship, methodReader);
            return methodReader;
        }
        FieldInfo fieldInfo = classInfo.relationshipField(relationshipType, relationshipDirection, true);
        if (fieldInfo != null && !fieldInfo.getAnnotations().isEmpty()) {
            FieldReader fieldReader = new FieldReader(classInfo, fieldInfo);
            relationalReaderCache.get(classInfo).put(directedRelationship, fieldReader);
            return fieldReader;
        }
        if (!relationshipDirection.equals("INCOMING")) {
            methodInfo = classInfo.relationshipGetter(relationshipType, relationshipDirection, false);
            if (methodInfo != null && !methodInfo.getAnnotations().isEmpty()) {
                MethodReader methodReader = new MethodReader(classInfo, methodInfo);
                relationalReaderCache.get(classInfo).put(directedRelationship, methodReader);
                return methodReader;
            }
            fieldInfo = classInfo.relationshipField(relationshipType, relationshipDirection, false);
            if (fieldInfo != null && !fieldInfo.getAnnotations().isEmpty()) {
                FieldReader fieldReader = new FieldReader(classInfo, fieldInfo);
                relationalReaderCache.get(classInfo).put(directedRelationship, fieldReader);
                return fieldReader;
            }
            if (methodInfo != null) {
                MethodReader methodReader = new MethodReader(classInfo, methodInfo);
                relationalReaderCache.get(classInfo).put(directedRelationship, methodReader);
                return methodReader;
            }
            if (fieldInfo != null) {
                FieldReader fieldReader = new FieldReader(classInfo, fieldInfo);
                relationalReaderCache.get(classInfo).put(directedRelationship, fieldReader);
                return fieldReader;
            }
        }
        relationalReaderCache.get(classInfo).put(directedRelationship, null);
        return null;
    }

    public static Collection<PropertyReader> getPropertyReaders(ClassInfo classInfo) {
        if (propertyReaders.containsKey(classInfo)) {
            return propertyReaders.get(classInfo);
        }
        ArrayList<PropertyReader> readers = new ArrayList<PropertyReader>();
        for (FieldInfo fieldInfo : classInfo.propertyFields()) {
            MethodInfo getterInfo = classInfo.propertyGetter(fieldInfo.property());
            if (getterInfo != null && (getterInfo.hasAnnotation("org.neo4j.ogm.annotation.Property") || fieldInfo.getAnnotations().isEmpty())) {
                readers.add(new MethodReader(classInfo, getterInfo));
                continue;
            }
            readers.add(new FieldReader(classInfo, fieldInfo));
        }
        propertyReaders.put(classInfo, readers);
        return readers;
    }

    public static Collection<RelationalReader> getRelationalReaders(ClassInfo classInfo) {
        if (relationalReaders.containsKey(classInfo)) {
            return relationalReaders.get(classInfo);
        }
        ArrayList<RelationalReader> readers = new ArrayList<RelationalReader>();
        for (FieldInfo fieldInfo : classInfo.relationshipFields()) {
            MethodInfo getterInfo = classInfo.methodsInfo().get(EntityAccessManager.inferGetterName(fieldInfo));
            if (getterInfo != null && (getterInfo.hasAnnotation("org.neo4j.ogm.annotation.Relationship") || !fieldInfo.hasAnnotation("org.neo4j.ogm.annotation.Relationship"))) {
                readers.add(new MethodReader(classInfo, getterInfo));
                continue;
            }
            readers.add(new FieldReader(classInfo, fieldInfo));
        }
        relationalReaders.put(classInfo, readers);
        return readers;
    }

    private static String inferGetterName(FieldInfo fieldInfo) {
        StringBuilder getterNameBuilder = new StringBuilder(fieldInfo.getName());
        getterNameBuilder.setCharAt(0, Character.toUpperCase(fieldInfo.getName().charAt(0)));
        return getterNameBuilder.insert(0, "get").toString();
    }

    public static RelationalWriter getIterableWriter(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection) {
        if (!iterableWriterCache.containsKey(classInfo)) {
            iterableWriterCache.put(classInfo, new HashMap());
        }
        DirectedRelationshipForType directedRelationshipForType = new DirectedRelationshipForType(relationshipType, relationshipDirection, parameterType);
        if (iterableWriterCache.get(classInfo).containsKey(directedRelationshipForType)) {
            return iterableWriterCache.get(classInfo).get(directedRelationshipForType);
        }
        MethodInfo methodInfo = EntityAccessManager.getIterableSetterMethodInfo(classInfo, parameterType, relationshipType, relationshipDirection, true);
        if (methodInfo != null) {
            MethodWriter methodWriter = new MethodWriter(classInfo, methodInfo);
            EntityAccessManager.cacheIterableMethodWriter(classInfo, parameterType, relationshipType, relationshipDirection, directedRelationshipForType, methodInfo, methodWriter);
            return methodWriter;
        }
        FieldInfo fieldInfo = EntityAccessManager.getIterableFieldInfo(classInfo, parameterType, relationshipType, relationshipDirection, true);
        if (fieldInfo != null) {
            FieldWriter fieldWriter = new FieldWriter(classInfo, fieldInfo);
            EntityAccessManager.cacheIterableFieldWriter(classInfo, parameterType, relationshipType, relationshipDirection, directedRelationshipForType, fieldInfo, fieldWriter);
            return fieldWriter;
        }
        if (!relationshipDirection.equals("INCOMING")) {
            methodInfo = EntityAccessManager.getIterableSetterMethodInfo(classInfo, parameterType, relationshipType, relationshipDirection, false);
            if (methodInfo != null) {
                MethodWriter methodWriter = new MethodWriter(classInfo, methodInfo);
                EntityAccessManager.cacheIterableMethodWriter(classInfo, parameterType, relationshipType, relationshipDirection, directedRelationshipForType, methodInfo, methodWriter);
                return methodWriter;
            }
            fieldInfo = EntityAccessManager.getIterableFieldInfo(classInfo, parameterType, relationshipType, relationshipDirection, false);
            if (fieldInfo != null) {
                FieldWriter fieldWriter = new FieldWriter(classInfo, fieldInfo);
                EntityAccessManager.cacheIterableFieldWriter(classInfo, parameterType, relationshipType, relationshipDirection, directedRelationshipForType, fieldInfo, fieldWriter);
                return fieldWriter;
            }
        }
        iterableWriterCache.get(classInfo).put(directedRelationshipForType, null);
        return null;
    }

    public static RelationalReader getIterableReader(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection) {
        if (!iterableReaderCache.containsKey(classInfo)) {
            iterableReaderCache.put(classInfo, new HashMap());
        }
        DirectedRelationshipForType directedRelationshipForType = new DirectedRelationshipForType(relationshipType, relationshipDirection, parameterType);
        if (iterableReaderCache.get(classInfo).containsKey(directedRelationshipForType)) {
            return iterableReaderCache.get(classInfo).get(directedRelationshipForType);
        }
        MethodInfo methodInfo = EntityAccessManager.getIterableGetterMethodInfo(classInfo, parameterType, relationshipType, relationshipDirection, true);
        if (methodInfo != null) {
            MethodReader methodReader = new MethodReader(classInfo, methodInfo);
            iterableReaderCache.get(classInfo).put(directedRelationshipForType, methodReader);
            return methodReader;
        }
        FieldInfo fieldInfo = EntityAccessManager.getIterableFieldInfo(classInfo, parameterType, relationshipType, relationshipDirection, true);
        if (fieldInfo != null) {
            FieldReader fieldReader = new FieldReader(classInfo, fieldInfo);
            iterableReaderCache.get(classInfo).put(directedRelationshipForType, fieldReader);
            return fieldReader;
        }
        if (!relationshipDirection.equals("INCOMING")) {
            methodInfo = EntityAccessManager.getIterableGetterMethodInfo(classInfo, parameterType, relationshipType, relationshipDirection, false);
            if (methodInfo != null) {
                MethodReader methodReader = new MethodReader(classInfo, methodInfo);
                iterableReaderCache.get(classInfo).put(directedRelationshipForType, methodReader);
                return methodReader;
            }
            fieldInfo = EntityAccessManager.getIterableFieldInfo(classInfo, parameterType, relationshipType, relationshipDirection, false);
            if (fieldInfo != null) {
                FieldReader fieldReader = new FieldReader(classInfo, fieldInfo);
                iterableReaderCache.get(classInfo).put(directedRelationshipForType, fieldReader);
                return fieldReader;
            }
        }
        iterableReaderCache.get(classInfo).put(directedRelationshipForType, null);
        return null;
    }

    public static PropertyReader getIdentityPropertyReader(ClassInfo classInfo) {
        PropertyReader propertyReader = identityPropertyReaderCache.get(classInfo);
        if (propertyReader != null) {
            return propertyReader;
        }
        propertyReader = new FieldReader(classInfo, classInfo.identityField());
        identityPropertyReaderCache.put(classInfo, propertyReader);
        return propertyReader;
    }

    public static RelationalReader getEndNodeReader(ClassInfo relationshipEntityClassInfo) {
        for (FieldInfo fieldInfo : relationshipEntityClassInfo.relationshipFields()) {
            if (fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.EndNode") == null) continue;
            return new FieldReader(relationshipEntityClassInfo, fieldInfo);
        }
        LOGGER.warn("Failed to find an @EndNode on {}", (Object)relationshipEntityClassInfo);
        return null;
    }

    public static RelationalReader getStartNodeReader(ClassInfo relationshipEntityClassInfo) {
        for (FieldInfo fieldInfo : relationshipEntityClassInfo.relationshipFields()) {
            if (fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.StartNode") == null) continue;
            return new FieldReader(relationshipEntityClassInfo, fieldInfo);
        }
        LOGGER.warn("Failed to find an @StartNode on {}", (Object)relationshipEntityClassInfo);
        return null;
    }

    public static RelationalWriter getRelationalEntityWriter(ClassInfo classInfo, Class entityAnnotation) {
        if (entityAnnotation.getName() == null) {
            throw new RuntimeException(entityAnnotation.getSimpleName() + " is not defined on " + classInfo.name());
        }
        if (relationshipEntityWriterCache.get(classInfo) == null) {
            relationshipEntityWriterCache.put(classInfo, new HashMap());
        }
        if (relationshipEntityWriterCache.get(classInfo).containsKey(entityAnnotation)) {
            return relationshipEntityWriterCache.get(classInfo).get(entityAnnotation);
        }
        FieldInfo field = null;
        for (FieldInfo fieldInfo : classInfo.relationshipFields()) {
            if (fieldInfo.getAnnotations().get(entityAnnotation.getName()) == null) continue;
            field = fieldInfo;
            break;
        }
        if (field != null) {
            String setter = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            for (MethodInfo methodInfo : classInfo.relationshipSetters()) {
                if (!methodInfo.getName().equals(setter)) continue;
                MethodWriter methodWriter = new MethodWriter(classInfo, methodInfo);
                relationshipEntityWriterCache.get(classInfo).put(entityAnnotation, methodWriter);
                return methodWriter;
            }
            FieldWriter fieldWriter = new FieldWriter(classInfo, field);
            relationshipEntityWriterCache.get(classInfo).put(entityAnnotation, fieldWriter);
            return fieldWriter;
        }
        relationshipEntityWriterCache.get(classInfo).put(entityAnnotation, null);
        return null;
    }

    private static MethodInfo getIterableSetterMethodInfo(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection, boolean strict) {
        List<MethodInfo> methodInfos = classInfo.findIterableSetters(parameterType, relationshipType, relationshipDirection, strict);
        if (methodInfos.size() == 0 && !strict) {
            methodInfos = classInfo.findIterableSetters(parameterType);
        }
        if (methodInfos.size() == 1) {
            AnnotationInfo relationshipAnnotation;
            MethodInfo candidateMethodInfo = methodInfos.iterator().next();
            if (candidateMethodInfo.hasAnnotation("org.neo4j.ogm.annotation.Relationship") && !relationshipType.equals((relationshipAnnotation = candidateMethodInfo.getAnnotations().get("org.neo4j.ogm.annotation.Relationship")).get("type", null))) {
                return null;
            }
            if (relationshipDirection.equals("INCOMING") && candidateMethodInfo.relationshipDirection("OUTGOING").equals("INCOMING") || candidateMethodInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED")) {
                return candidateMethodInfo;
            }
            if (!relationshipDirection.equals("INCOMING") && !candidateMethodInfo.relationshipDirection("OUTGOING").equals("INCOMING")) {
                return candidateMethodInfo;
            }
        }
        if (methodInfos.size() > 0) {
            LOGGER.warn("Cannot map iterable of {} to instance of {}. More than one potential matching setter found.", parameterType, (Object)classInfo.name());
        }
        return null;
    }

    private static MethodInfo getIterableGetterMethodInfo(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection, boolean strict) {
        List<MethodInfo> methodInfos = classInfo.findIterableGetters(parameterType, relationshipType, relationshipDirection, strict);
        if (methodInfos.size() == 0 && !strict) {
            methodInfos = classInfo.findIterableGetters(parameterType);
        }
        if (methodInfos.size() == 1) {
            AnnotationInfo relationshipAnnotation;
            MethodInfo candidateMethodInfo = methodInfos.iterator().next();
            if (candidateMethodInfo.hasAnnotation("org.neo4j.ogm.annotation.Relationship") && !relationshipType.equals((relationshipAnnotation = candidateMethodInfo.getAnnotations().get("org.neo4j.ogm.annotation.Relationship")).get("type", null))) {
                return null;
            }
            if (relationshipDirection.equals("INCOMING") && candidateMethodInfo.relationshipDirection("OUTGOING").equals("INCOMING") || candidateMethodInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED")) {
                return candidateMethodInfo;
            }
            if (!relationshipDirection.equals("INCOMING") && !candidateMethodInfo.relationshipDirection("OUTGOING").equals("INCOMING")) {
                return candidateMethodInfo;
            }
        }
        if (methodInfos.size() > 0) {
            LOGGER.warn("Cannot map iterable of {} to instance of {}.  More than one potential matching getter found.", parameterType, (Object)classInfo.name());
        }
        return null;
    }

    private static FieldInfo getIterableFieldInfo(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection, boolean strict) {
        List<FieldInfo> fieldInfos = classInfo.findIterableFields(parameterType, relationshipType, relationshipDirection, strict);
        if (fieldInfos.size() == 0 && !strict) {
            fieldInfos = classInfo.findIterableFields(parameterType);
        }
        if (fieldInfos.size() == 1) {
            AnnotationInfo relationshipAnnotation;
            FieldInfo candidateFieldInfo = fieldInfos.iterator().next();
            if (candidateFieldInfo.hasAnnotation("org.neo4j.ogm.annotation.Relationship") && !relationshipType.equals((relationshipAnnotation = candidateFieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.Relationship")).get("type", null))) {
                return null;
            }
            if (relationshipDirection.equals("INCOMING") && candidateFieldInfo.relationshipDirection("OUTGOING").equals("INCOMING") || candidateFieldInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED")) {
                return candidateFieldInfo;
            }
            if (!relationshipDirection.equals("INCOMING") && !candidateFieldInfo.relationshipDirection("OUTGOING").equals("INCOMING")) {
                return candidateFieldInfo;
            }
        }
        if (fieldInfos.size() > 0) {
            LOGGER.warn("Cannot map iterable of {} to instance of {}. More than one potential matching field found.", parameterType, (Object)classInfo.name());
        }
        return null;
    }

    private static void cacheIterableFieldWriter(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection, DirectedRelationshipForType directedRelationshipForType, FieldInfo fieldInfo, FieldWriter fieldWriter) {
        if (fieldInfo.isParameterisedTypeOf(parameterType)) {
            directedRelationshipForType = new DirectedRelationshipForType(relationshipType, relationshipDirection, ClassUtils.getType(fieldInfo.getTypeParameterDescriptor()));
        }
        iterableWriterCache.get(classInfo).put(directedRelationshipForType, fieldWriter);
    }

    private static void cacheIterableMethodWriter(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection, DirectedRelationshipForType directedRelationshipForType, MethodInfo methodInfo, MethodWriter methodWriter) {
        if (methodInfo.isParameterisedTypeOf(parameterType)) {
            directedRelationshipForType = new DirectedRelationshipForType(relationshipType, relationshipDirection, ClassUtils.getType(methodInfo.getTypeParameterDescriptor()));
        }
        iterableWriterCache.get(classInfo).put(directedRelationshipForType, methodWriter);
    }

    private static interface AccessorFactory<T> {
        public T makeMethodAccessor(MethodInfo var1);

        public T makeFieldAccessor(FieldInfo var1);
    }
}

