/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context.register;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRegister {
    private final Logger LOGGER = LoggerFactory.getLogger(EntityRegister.class);
    private final ConcurrentMap<Long, Object> register = new ConcurrentHashMap<Long, Object>();

    public Object get(Long id) {
        return this.register.get(id);
    }

    public boolean add(Long id, Object entity) {
        if (this.register.putIfAbsent(id, entity) == null) {
            this.LOGGER.debug("Added object to node registry: {}, {}", (Object)id, entity);
            return true;
        }
        this.LOGGER.debug("Object already in node registry: {}, {}", (Object)id, entity);
        return false;
    }

    public boolean contains(Long id) {
        return this.register.containsKey(id);
    }

    public void remove(Long id) {
        this.LOGGER.debug("Removed object with id {}", (Object)id);
        this.register.remove(id);
    }

    public void clear() {
        this.LOGGER.debug("Register has been cleared");
        this.register.clear();
    }

    public Iterator<Long> iterator() {
        return this.register.keySet().iterator();
    }
}

