/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.annotations.DefaultEntityAccessStrategy;
import org.neo4j.ogm.annotations.FieldWriter;
import org.neo4j.ogm.annotations.PropertyReader;
import org.neo4j.ogm.compiler.CompileContext;
import org.neo4j.ogm.compiler.Compiler;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.TransientRelationship;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.DefaultRequest;
import org.neo4j.ogm.session.request.RowStatementFactory;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestExecutor.class);
    private Neo4jSession session;

    public RequestExecutor(Neo4jSession session) {
        this.session = session;
    }

    public void executeSave(CompileContext context) {
        Compiler compiler = context.getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        ArrayList<ReferenceMapping> entityReferenceMappings = new ArrayList<ReferenceMapping>();
        ArrayList<ReferenceMapping> relReferenceMappings = new ArrayList<ReferenceMapping>();
        if (compiler.hasStatementsDependentOnNewNodes()) {
            boolean manageTransaction = false;
            Transaction tx = this.session.getTransaction();
            if (tx == null) {
                tx = this.session.beginTransaction();
                manageTransaction = true;
            }
            DefaultRequest createNodesRowRequest = new DefaultRequest();
            createNodesRowRequest.setStatements(compiler.createNodesStatements());
            try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)createNodesRowRequest);){
                this.registerEntityIds(context, (Response<RowModel>)response, entityReferenceMappings, relReferenceMappings);
            }
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.addAll(compiler.createRelationshipsStatements());
            statements.addAll(compiler.updateNodesStatements());
            statements.addAll(compiler.updateRelationshipStatements());
            statements.addAll(compiler.deleteRelationshipStatements());
            statements.addAll(compiler.deleteRelationshipEntityStatements());
            DefaultRequest defaultRequest = new DefaultRequest();
            defaultRequest.setStatements(statements);
            try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)defaultRequest);){
                this.registerEntityIds(context, (Response<RowModel>)response, entityReferenceMappings, relReferenceMappings);
                this.registerNewRelIds((Response<RowModel>)response, relReferenceMappings);
            }
            if (manageTransaction) {
                tx.commit();
            }
        } else {
            List statements = compiler.getAllStatements();
            if (statements.size() > 0) {
                DefaultRequest defaultRequest = new DefaultRequest();
                defaultRequest.setStatements(statements);
                try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)defaultRequest);){
                    this.registerEntityIds(context, (Response<RowModel>)response, entityReferenceMappings, relReferenceMappings);
                    this.registerNewRelIds((Response<RowModel>)response, relReferenceMappings);
                }
            }
        }
        this.updateNodeEntities(context, this.session, entityReferenceMappings);
        this.updateRelationshipEntities(context, this.session, relReferenceMappings);
        this.updateRelationships(context, this.session, relReferenceMappings);
    }

    public void executeSave(List<CompileContext> contexts) {
        ArrayList<ReferenceMapping> entityReferenceMappings = new ArrayList<ReferenceMapping>();
        ArrayList<ReferenceMapping> relReferenceMappings = new ArrayList<ReferenceMapping>();
        ArrayList<Statement> statements = new ArrayList<Statement>();
        boolean manageTransaction = false;
        Transaction tx = this.session.getTransaction();
        if (tx == null) {
            tx = this.session.beginTransaction();
            manageTransaction = true;
        }
        for (CompileContext context : contexts) {
            Compiler compiler = context.getCompiler();
            compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
            if (compiler.hasStatementsDependentOnNewNodes()) {
                DefaultRequest createNodesRowRequest = new DefaultRequest();
                createNodesRowRequest.setStatements(compiler.createNodesStatements());
                try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)createNodesRowRequest);){
                    this.registerEntityIds(context, (Response<RowModel>)response, entityReferenceMappings, relReferenceMappings);
                }
                statements.addAll(compiler.createRelationshipsStatements());
                statements.addAll(compiler.updateNodesStatements());
                statements.addAll(compiler.updateRelationshipStatements());
                statements.addAll(compiler.deleteRelationshipStatements());
                statements.addAll(compiler.deleteRelationshipEntityStatements());
                continue;
            }
            statements.addAll(compiler.getAllStatements());
        }
        if (statements.size() > 0) {
            DefaultRequest defaultRequest = new DefaultRequest();
            defaultRequest.setStatements(statements);
            try (Response response = this.session.requestHandler().execute((org.neo4j.ogm.request.DefaultRequest)defaultRequest);){
                for (CompileContext context : contexts) {
                    this.registerEntityIds(context, (Response<RowModel>)response, entityReferenceMappings, relReferenceMappings);
                }
                this.registerNewRelIds((Response<RowModel>)response, relReferenceMappings);
            }
        }
        if (manageTransaction) {
            tx.commit();
        }
        for (CompileContext context : contexts) {
            this.updateNodeEntities(context, this.session, entityReferenceMappings);
            this.updateRelationshipEntities(context, this.session, relReferenceMappings);
            this.updateRelationships(context, this.session, relReferenceMappings);
        }
    }

    private void registerEntityIds(CompileContext context, Response<RowModel> response, List<ReferenceMapping> entityRefMappings, List<ReferenceMapping> relEntityRefMappings) {
        RowModel rowModel;
        while ((rowModel = (RowModel)response.next()) != null) {
            Object[] results = rowModel.getValues();
            String[] variables = rowModel.variables();
            Long entityRef = null;
            Long entityId = null;
            String type = null;
            for (int i = 0; i < variables.length; ++i) {
                if (variables[i].equals("id")) {
                    entityId = ((Number)results[i]).longValue();
                }
                if (variables[i].equals("ref")) {
                    entityRef = ((Number)results[i]).longValue();
                }
                if (!variables[i].equals("type")) continue;
                type = (String)results[i];
            }
            if (type != null && type.equals("node")) {
                entityRefMappings.add(new ReferenceMapping(entityRef, entityId));
                if (entityRef != null && entityRef.equals(entityId)) {
                    LOGGER.debug("to update: nodeEntity {}:{}", (Object)entityRef, (Object)entityId);
                    continue;
                }
                LOGGER.debug("to create: nodeEntity {}:{}", (Object)entityRef, (Object)entityId);
                context.registerNewId(entityRef, entityId);
                continue;
            }
            if (type == null || !type.equals("rel")) continue;
            relEntityRefMappings.add(new ReferenceMapping(entityRef, entityId));
            if (entityRef != null && entityRef.equals(entityId)) {
                LOGGER.debug("to (maybe) update: relEntity {}:{}", (Object)entityRef, (Object)entityId);
                continue;
            }
            LOGGER.debug("to (maybe) create: relEntity {}:{}", (Object)entityRef, (Object)entityId);
            context.registerNewId(entityRef, entityId);
        }
    }

    private void registerNewRelIds(Response<RowModel> response, List<ReferenceMapping> relRefMappings) {
        RowModel rowModel;
        while ((rowModel = (RowModel)response.next()) != null) {
            Object[] results = rowModel.getValues();
            Long relRef = ((Number)results[0]).longValue();
            Long relId = ((Number)results[1]).longValue();
            relRefMappings.add(new ReferenceMapping(relRef, relId));
        }
    }

    private void updateNodeEntities(CompileContext context, Neo4jSession session, List<ReferenceMapping> entityRefMappings) {
        for (ReferenceMapping referenceMapping : entityRefMappings) {
            Object newEntity = context.getNewObject(referenceMapping.ref);
            if (referenceMapping.ref.equals(referenceMapping.id)) {
                LOGGER.debug("updating existing node id: {}", (Object)referenceMapping.id);
                Object existingNodeEntity = session.context().getNodeEntity(referenceMapping.id);
                if (existingNodeEntity != null) {
                    ClassInfo classInfo = session.metaData().classInfo(existingNodeEntity);
                    RequestExecutor.registerEntity(session.context(), classInfo, referenceMapping.id, existingNodeEntity);
                    continue;
                }
                for (Object obj : context.registry()) {
                    ClassInfo classInfo;
                    PropertyReader idReader;
                    Long id;
                    if (obj instanceof TransientRelationship || (id = (Long)(idReader = new DefaultEntityAccessStrategy().getIdentityPropertyReader(classInfo = session.metaData().classInfo(obj))).read(obj)) == null || !id.equals(referenceMapping.id)) continue;
                    RequestExecutor.registerEntity(session.context(), classInfo, referenceMapping.id, obj);
                }
                continue;
            }
            LOGGER.debug("creating new node id: {}", (Object)referenceMapping.id);
            RequestExecutor.initialiseNewEntity(referenceMapping.id, newEntity, session);
        }
    }

    private void updateRelationshipEntities(CompileContext context, Neo4jSession session, List<ReferenceMapping> relationshipEntityRefMappings) {
        for (ReferenceMapping referenceMapping : relationshipEntityRefMappings) {
            if (referenceMapping.ref.equals(referenceMapping.id)) {
                Object existingRelationshipEntity = session.context().getRelationshipEntity(referenceMapping.id);
                if (existingRelationshipEntity == null) continue;
                LOGGER.debug("updating existing relationship entity id: {}", (Object)referenceMapping.id);
                ClassInfo classInfo = session.metaData().classInfo(existingRelationshipEntity);
                RequestExecutor.registerEntity(session.context(), classInfo, referenceMapping.id, existingRelationshipEntity);
                continue;
            }
            Object newRelationshipEntity = context.getNewObject(referenceMapping.ref);
            if (newRelationshipEntity == null) continue;
            LOGGER.debug("creating new relationship entity id: {}", (Object)referenceMapping.id);
            RequestExecutor.initialiseNewEntity(referenceMapping.id, newRelationshipEntity, session);
        }
    }

    private void updateRelationships(CompileContext context, Neo4jSession session, List<ReferenceMapping> relRefMappings) {
        for (ReferenceMapping referenceMapping : relRefMappings) {
            for (Object obj : context.registry()) {
                if (!(obj instanceof TransientRelationship)) continue;
                TransientRelationship transientRelationship = (TransientRelationship)obj;
                if (!referenceMapping.ref.equals(transientRelationship.getRef())) continue;
                MappedRelationship mappedRelationship = new MappedRelationship(context.getId(transientRelationship.getSrc()), transientRelationship.getRel(), context.getId(transientRelationship.getTgt()), transientRelationship.getSrcClass(), transientRelationship.getTgtClass());
                if (session.context().getRelationshipEntity(referenceMapping.id) != null) {
                    mappedRelationship.setRelationshipId(referenceMapping.id);
                }
                session.context().mappedRelationships().add(mappedRelationship);
            }
        }
    }

    private static void initialiseNewEntity(Long identity, Object persisted, Neo4jSession session) {
        MappingContext mappingContext = session.context();
        Transaction tx = session.getTransaction();
        if (persisted != null) {
            ClassInfo classInfo = session.metaData().classInfo(persisted);
            Field identityField = classInfo.getField(classInfo.identityField());
            FieldWriter.write(identityField, persisted, identity);
            if (tx != null) {
                ((AbstractTransaction)tx).registerNew(persisted);
            }
            RequestExecutor.registerEntity(mappingContext, classInfo, identity, persisted);
        }
    }

    private static void registerEntity(MappingContext mappingContext, ClassInfo classInfo, Long identity, Object entity) {
        if (classInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity") == null) {
            mappingContext.registerNodeEntity(entity, identity);
        } else {
            mappingContext.registerRelationshipEntity(entity, identity);
        }
    }

    class ReferenceMapping {
        private Long ref;
        private Long id;

        ReferenceMapping(Long ref, Long id) {
            this.ref = ref;
            this.id = id;
        }
    }
}

