/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.annotations;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.neo4j.ogm.annotations.PropertyWriter;
import org.neo4j.ogm.annotations.RelationalWriter;
import org.neo4j.ogm.session.Utils;

public abstract class EntityAccess
implements PropertyWriter,
RelationalWriter {
    public static Object merge(Class<?> parameterType, Object newValues, Object[] currentValues, Class elementType) {
        if (currentValues != null) {
            return EntityAccess.merge(parameterType, newValues, Arrays.asList(currentValues), elementType);
        }
        return EntityAccess.merge(parameterType, newValues, new ArrayList(), elementType);
    }

    public static Object merge(Class<?> parameterType, Object newValues, Collection currentValues, Class elementType) {
        if (newValues != null) {
            newValues = EntityAccess.boxPrimitiveArray(newValues);
            newValues = EntityAccess.stringToCharacterIterable(newValues, parameterType, elementType);
        }
        if (parameterType.isArray()) {
            Class<?> type = parameterType.getComponentType();
            ArrayList<Object> objects = new ArrayList<Object>(EntityAccess.union((Collection)newValues, currentValues, elementType));
            Object array = Array.newInstance(type, objects.size());
            for (int i = 0; i < objects.size(); ++i) {
                Array.set(array, i, objects.get(i));
            }
            return array;
        }
        Collection<?> newCollection = EntityAccess.createCollection(parameterType, (Collection)newValues, currentValues, elementType);
        if (newCollection != null) {
            return newCollection;
        }
        if (parameterType.isAssignableFrom(newValues.getClass())) {
            return newValues;
        }
        throw new RuntimeException("Unsupported: " + parameterType.getName());
    }

    private static Collection<?> createCollection(Class<?> parameterType, Collection collection, Collection hydrated, Class elementType) {
        if (Vector.class.isAssignableFrom(parameterType)) {
            return new Vector<Object>(EntityAccess.union(collection, hydrated, elementType));
        }
        if (List.class.isAssignableFrom(parameterType)) {
            return new ArrayList<Object>(EntityAccess.union(collection, hydrated, elementType));
        }
        if (SortedSet.class.isAssignableFrom(parameterType)) {
            return new TreeSet<Object>(EntityAccess.union(collection, hydrated, elementType));
        }
        if (Set.class.isAssignableFrom(parameterType)) {
            return new HashSet<Object>(EntityAccess.union(collection, hydrated, elementType));
        }
        return null;
    }

    private static Collection<Object> union(Collection collection, Collection hydrated, Class elementType) {
        if (collection == null) {
            return hydrated;
        }
        if (hydrated == null || hydrated.size() == 0) {
            ArrayList<Object> result = new ArrayList<Object>(collection.size());
            for (Object object : collection) {
                result.add(Utils.coerceTypes(elementType, object));
            }
            return result;
        }
        int resultSize = collection.size();
        if (hydrated != null) {
            resultSize += hydrated.size();
        }
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(resultSize);
        if (hydrated != null && hydrated.size() > collection.size()) {
            result.addAll(hydrated);
            EntityAccess.addToCollection(collection, result, elementType);
        } else {
            EntityAccess.addToCollection(collection, result, elementType);
            if (hydrated != null) {
                EntityAccess.addToCollection(hydrated, result, elementType);
            }
        }
        return result;
    }

    private static void addToCollection(Collection add, Collection<Object> addTo, Class elementType) {
        for (Object object : add) {
            addTo.add(Utils.coerceTypes(elementType, object));
        }
    }

    private static Object stringToCharacterIterable(Object value, Class parameterType, Class elementType) {
        boolean convertCharacters = false;
        if (value instanceof String) {
            char[] chars = ((String)value).toCharArray();
            ArrayList<Character> characters = new ArrayList<Character>(chars.length);
            for (char c : chars) {
                characters.add(Character.valueOf(c));
            }
            return characters;
        }
        if (parameterType.getComponentType() != null) {
            if (parameterType.getComponentType().equals(Character.class)) {
                convertCharacters = true;
            }
        } else if (elementType == Character.class || elementType == Character.TYPE) {
            convertCharacters = true;
        }
        if (value.getClass().isArray() && convertCharacters && value.getClass().getComponentType().equals(String.class)) {
            String[] strings = (String[])value;
            ArrayList<Character> characters = new ArrayList<Character>(strings.length);
            for (String s : strings) {
                characters.add(Character.valueOf(s.toCharArray()[0]));
            }
            return characters;
        }
        if (value.getClass().isArray() && elementType == String.class) {
            String[] strings = (String[])value;
            return Arrays.asList(strings);
        }
        return value;
    }

    private static Object boxPrimitiveArray(Object value) {
        if (value.getClass().isArray() && value.getClass().getComponentType().isPrimitive()) {
            switch (value.getClass().getComponentType().toString()) {
                case "int": {
                    int[] intArray = (int[])value;
                    ArrayList<Integer> boxedIntList = new ArrayList<Integer>(intArray.length);
                    for (int i : intArray) {
                        boxedIntList.add(i);
                    }
                    return boxedIntList;
                }
                case "float": {
                    float[] floatArray = (float[])value;
                    ArrayList<Float> boxedFloatList = new ArrayList<Float>(floatArray.length);
                    for (float f : floatArray) {
                        boxedFloatList.add(Float.valueOf(f));
                    }
                    return boxedFloatList;
                }
                case "long": {
                    long[] longArray = (long[])value;
                    ArrayList<Long> boxedLongList = new ArrayList<Long>(longArray.length);
                    for (long l : longArray) {
                        boxedLongList.add(l);
                    }
                    return boxedLongList;
                }
                case "double": {
                    double[] dblArray = (double[])value;
                    ArrayList<Double> boxedDoubleList = new ArrayList<Double>(dblArray.length);
                    for (double d : dblArray) {
                        boxedDoubleList.add(d);
                    }
                    return boxedDoubleList;
                }
                case "boolean": {
                    boolean[] booleanArray = (boolean[])value;
                    ArrayList<Boolean> boxedBooleanList = new ArrayList<Boolean>(booleanArray.length);
                    for (boolean b : booleanArray) {
                        boxedBooleanList.add(b);
                    }
                    return boxedBooleanList;
                }
                case "char": {
                    char[] charArray = (char[])value;
                    ArrayList<Character> boxedCharList = new ArrayList<Character>(charArray.length);
                    for (char c : charArray) {
                        boxedCharList.add(Character.valueOf(c));
                    }
                    return boxedCharList;
                }
            }
        }
        return value;
    }
}

