/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.AbstractRequest;
import org.neo4j.ogm.cypher.query.DefaultGraphModelRequest;
import org.neo4j.ogm.cypher.query.DefaultGraphRowListModelRequest;
import org.neo4j.ogm.exception.MissingOperatorException;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.session.request.strategy.QueryStatements;

public class VariableDepthQuery
implements QueryStatements {
    @Override
    public AbstractRequest findOne(Long id, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findOne(id);
        }
        if (max > 0) {
            String qry = String.format("MATCH (n) WHERE id(n) = { id } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", min, max);
            return new DefaultGraphModelRequest(qry, Utils.map("id", id));
        }
        return DepthZeroReadStrategy.findOne(id);
    }

    @Override
    public AbstractRequest findAll(Collection<Long> ids, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findAll(ids);
        }
        if (max > 0) {
            String qry = String.format("MATCH (n) WHERE id(n) in { ids } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", min, max);
            return new DefaultGraphModelRequest(qry, Utils.map("ids", ids));
        }
        return DepthZeroReadStrategy.findAll(ids);
    }

    @Override
    public AbstractRequest findAllByType(String label, Collection<Long> ids, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findAllByLabel(label, ids);
        }
        if (max > 0) {
            String qry = String.format("MATCH (n:`%s`) WHERE id(n) in { ids } WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", label, min, max);
            return new DefaultGraphModelRequest(qry, Utils.map("ids", ids));
        }
        return DepthZeroReadStrategy.findAllByLabel(label, ids);
    }

    @Override
    public AbstractRequest findAll() {
        return new DefaultGraphModelRequest("MATCH p=()-->() RETURN p", Utils.map(new Object[0]));
    }

    @Override
    public AbstractRequest findByType(String label, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findByLabel(label);
        }
        if (max > 0) {
            String qry = String.format("MATCH (n:`%s`) WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p", label, min, max);
            return new DefaultGraphModelRequest(qry, Utils.map(new Object[0]));
        }
        return DepthZeroReadStrategy.findByLabel(label);
    }

    @Override
    public AbstractRequest findByProperties(String label, Filters parameters, int depth) {
        int max = this.max(depth);
        int min = this.min(max);
        if (depth < 0) {
            return InfiniteDepthReadStrategy.findByProperties(label, parameters);
        }
        if (max > 0) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            StringBuilder query = VariableDepthQuery.constructQuery(label, parameters, properties);
            query.append(String.format("WITH n MATCH p=(n)-[*%d..%d]-(m) RETURN p, ID(n)", min, max));
            return new DefaultGraphRowListModelRequest(query.toString(), properties);
        }
        return DepthZeroReadStrategy.findByProperties(label, parameters);
    }

    private static StringBuilder constructQuery(String label, Filters filters, Map<String, Object> properties) {
        LinkedHashMap<String, StringBuilder> matchClauses = new LinkedHashMap<String, StringBuilder>();
        HashMap<String, String> matchClauseIdentifiers = new HashMap<String, String>();
        ArrayList<StringBuilder> relationshipClauses = new ArrayList<StringBuilder>();
        int matchClauseId = 0;
        boolean noneOperatorEncountered = false;
        String nodeIdentifier = "n";
        VariableDepthQuery.createOrFetchMatchClause(label, nodeIdentifier, matchClauses);
        for (Filter filter : filters) {
            StringBuilder matchClause;
            if (filter.getBooleanOperator().equals((Object)BooleanOperator.NONE)) {
                if (noneOperatorEncountered) {
                    throw new MissingOperatorException("BooleanOperator missing for filter with property name " + filter.getPropertyName() + ". Only the first filter may not specify the BooleanOperator.");
                }
                noneOperatorEncountered = true;
            }
            if (filter.isNested()) {
                if (filter.getBooleanOperator().equals((Object)BooleanOperator.OR)) {
                    throw new UnsupportedOperationException("OR is not supported for nested properties on an entity");
                }
                nodeIdentifier = "m" + matchClauseId;
                if (filter.isNestedRelationshipEntity()) {
                    matchClause = VariableDepthQuery.constructRelationshipClause(filter, nodeIdentifier);
                    matchClauses.put(filter.getRelationshipType(), matchClause);
                    nodeIdentifier = "r";
                } else {
                    if (matchClauseIdentifiers.containsKey(filter.getNestedEntityTypeLabel())) {
                        nodeIdentifier = (String)matchClauseIdentifiers.get(filter.getNestedEntityTypeLabel());
                    } else {
                        matchClauseIdentifiers.put(filter.getNestedEntityTypeLabel(), nodeIdentifier);
                        relationshipClauses.add(VariableDepthQuery.constructRelationshipClause(filter, nodeIdentifier));
                    }
                    matchClause = VariableDepthQuery.createOrFetchMatchClause(filter.getNestedEntityTypeLabel(), nodeIdentifier, matchClauses);
                }
                ++matchClauseId;
            } else {
                nodeIdentifier = "n";
                matchClause = VariableDepthQuery.createOrFetchMatchClause(label, nodeIdentifier, matchClauses);
            }
            VariableDepthQuery.appendFilter(filter, nodeIdentifier, matchClause, properties);
        }
        return VariableDepthQuery.buildQuery(matchClauses, relationshipClauses);
    }

    private static StringBuilder buildQuery(Map<String, StringBuilder> matchClauses, List<StringBuilder> relationshipClauses) {
        StringBuilder query = new StringBuilder();
        for (StringBuilder matchClause : matchClauses.values()) {
            query.append((CharSequence)matchClause);
        }
        for (StringBuilder relationshipClause : relationshipClauses) {
            query.append((CharSequence)relationshipClause);
        }
        return query;
    }

    private static void appendFilter(Filter filter, String nodeIdentifier, StringBuilder query, Map<String, Object> properties) {
        String uniquePropertyName = filter.getPropertyName();
        if (filter.isNested()) {
            uniquePropertyName = filter.getNestedPropertyName() + "_" + filter.getPropertyName();
        }
        if (query.indexOf(" WHERE ") == -1) {
            query.append("WHERE ");
        } else if (!filter.getBooleanOperator().equals((Object)BooleanOperator.NONE)) {
            query.append(filter.getBooleanOperator().getValue()).append(" ");
        }
        String propertyExpressionPattern = filter.isNegated() ? "NOT(%s.`%s` %s { `%s` }) " : "%s.`%s` %s { `%s` } ";
        query.append(String.format(propertyExpressionPattern, nodeIdentifier, filter.getPropertyName(), filter.getComparisonOperator().getValue(), uniquePropertyName));
        properties.put(uniquePropertyName, filter.getTransformedPropertyValue());
    }

    private static StringBuilder constructRelationshipClause(Filter filter, String nodeIdentifier) {
        StringBuilder relationshipMatch = new StringBuilder("MATCH (n)");
        if (filter.getRelationshipDirection().equals("INCOMING")) {
            relationshipMatch.append("<");
        }
        relationshipMatch.append(String.format("-[%s:`%s`]-", filter.isNestedRelationshipEntity() ? "r" : "", filter.getRelationshipType()));
        if (filter.getRelationshipDirection().equals("OUTGOING")) {
            relationshipMatch.append(">");
        }
        relationshipMatch.append(String.format("(%s) ", nodeIdentifier));
        return relationshipMatch;
    }

    private static StringBuilder createOrFetchMatchClause(String label, String nodeIdentifier, Map<String, StringBuilder> matchClauses) {
        if (matchClauses.containsKey(label)) {
            return matchClauses.get(label);
        }
        StringBuilder matchClause = new StringBuilder();
        matchClause.append(String.format("MATCH (%s:`%s`) ", nodeIdentifier, label));
        matchClauses.put(label, matchClause);
        return matchClause;
    }

    private int min(int depth) {
        return Math.min(0, depth);
    }

    private int max(int depth) {
        return Math.max(0, depth);
    }

    private static class InfiniteDepthReadStrategy {
        private InfiniteDepthReadStrategy() {
        }

        public static DefaultGraphModelRequest findOne(Long id) {
            return new DefaultGraphModelRequest("MATCH (n) WHERE id(n) = { id } WITH n MATCH p=(n)-[*0..]-(m) RETURN p", Utils.map("id", id));
        }

        public static DefaultGraphModelRequest findAll(Collection<Long> ids) {
            return new DefaultGraphModelRequest("MATCH (n) WHERE id(n) in { ids } WITH n MATCH p=(n)-[*0..]-(m) RETURN p", Utils.map("ids", ids));
        }

        public static DefaultGraphModelRequest findAllByLabel(String label, Collection<Long> ids) {
            return new DefaultGraphModelRequest(String.format("MATCH (n:`%s`) WHERE id(n) in { ids } WITH n MATCH p=(n)-[*0..]-(m) RETURN p", label), Utils.map("ids", ids));
        }

        public static DefaultGraphModelRequest findByLabel(String label) {
            return new DefaultGraphModelRequest(String.format("MATCH (n:`%s`) WITH n MATCH p=(n)-[*0..]-(m) RETURN p", label), Utils.map(new Object[0]));
        }

        public static DefaultGraphRowListModelRequest findByProperties(String label, Filters parameters) {
            HashMap properties = new HashMap();
            StringBuilder query = VariableDepthQuery.constructQuery(label, parameters, properties);
            query.append(" WITH n MATCH p=(n)-[*0..]-(m) RETURN p, ID(n)");
            return new DefaultGraphRowListModelRequest(query.toString(), properties);
        }
    }

    private static class DepthZeroReadStrategy {
        private DepthZeroReadStrategy() {
        }

        public static DefaultGraphModelRequest findOne(Long id) {
            return new DefaultGraphModelRequest("MATCH (n) WHERE id(n) = { id } RETURN n", Utils.map("id", id));
        }

        public static DefaultGraphModelRequest findAll(Collection<Long> ids) {
            return new DefaultGraphModelRequest("MATCH (n) WHERE id(n) in { ids } RETURN n", Utils.map("ids", ids));
        }

        public static DefaultGraphModelRequest findAllByLabel(String label, Collection<Long> ids) {
            return new DefaultGraphModelRequest(String.format("MATCH (n:`%s`) WHERE id(n) in { ids } RETURN n", label), Utils.map("ids", ids));
        }

        public static DefaultGraphModelRequest findByLabel(String label) {
            return new DefaultGraphModelRequest(String.format("MATCH (n:`%s`) RETURN n", label), Utils.map(new Object[0]));
        }

        public static DefaultGraphModelRequest findByProperties(String label, Filters parameters) {
            HashMap properties = new HashMap();
            StringBuilder query = VariableDepthQuery.constructQuery(label, parameters, properties);
            query.append("RETURN n");
            return new DefaultGraphModelRequest(query.toString(), properties);
        }
    }
}

