/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.query;

import java.util.ArrayList;
import java.util.List;

public class SortOrder {
    private List<SortClause> sortClauses = new ArrayList<SortClause>();

    public SortOrder add(Direction direction, String ... properties) {
        this.sortClauses.add(new SortClause(direction, properties));
        return this;
    }

    public SortOrder add(String ... properties) {
        this.sortClauses.add(new SortClause(Direction.ASC, properties));
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.sortClauses.isEmpty()) {
            sb.append(" ORDER BY ");
            for (SortClause ordering : this.sortClauses) {
                sb.append(ordering);
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    class SortClause {
        private final Direction direction;
        private final String[] properties;

        public SortClause(Direction direction, String ... properties) {
            this.direction = direction;
            this.properties = properties;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.properties.length > 0) {
                for (String n : this.properties) {
                    sb.append("$." + n);
                    if (this.direction == Direction.DESC) {
                        sb.append(" DESC");
                    }
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
    }

    public static enum Direction {
        ASC,
        DESC;

    }
}

