/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.annotations.DefaultEntityAccessStrategy;
import org.neo4j.ogm.annotations.EntityAccess;
import org.neo4j.ogm.annotations.EntityAccessStrategy;
import org.neo4j.ogm.annotations.EntityFactory;
import org.neo4j.ogm.annotations.FieldWriter;
import org.neo4j.ogm.annotations.PropertyWriter;
import org.neo4j.ogm.exception.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.model.RowModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleUseEntityMapper {
    private static final Logger logger = LoggerFactory.getLogger(SingleUseEntityMapper.class);
    private final EntityAccessStrategy entityAccessStrategy;
    private final EntityFactory entityFactory;
    private final MetaData metadata;

    public SingleUseEntityMapper(MetaData mappingMetaData, EntityFactory entityFactory) {
        this.metadata = mappingMetaData;
        this.entityFactory = new EntityFactory(mappingMetaData);
        this.entityAccessStrategy = new DefaultEntityAccessStrategy();
    }

    public <T> T map(Class<T> type, String[] columnNames, RowModel rowModel) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < rowModel.getValues().length; ++i) {
            properties.put(columnNames[i], rowModel.getValues()[i]);
        }
        T entity = this.entityFactory.newObject(type);
        this.setPropertiesOnEntity(entity, properties);
        return entity;
    }

    public <T> T map(Class<T> type, Map<String, Object> row) {
        T entity = this.entityFactory.newObject(type);
        this.setPropertiesOnEntity(entity, row);
        return entity;
    }

    private void setPropertiesOnEntity(Object entity, Map<String, Object> propertyMap) {
        ClassInfo classInfo = this.resolveClassInfoFor(entity.getClass());
        for (Map.Entry<String, Object> propertyMapEntry : propertyMap.entrySet()) {
            this.writeProperty(classInfo, entity, propertyMapEntry);
        }
    }

    private ClassInfo resolveClassInfoFor(Class<?> type) {
        ClassInfo classInfo = this.metadata.classInfo(type.getSimpleName());
        if (classInfo != null) {
            return classInfo;
        }
        throw new MappingException("Error mapping to ad-hoc " + type + ".  At present, only @Result types that are discovered by the domain entity package scanning can be mapped.");
    }

    private void writeProperty(ClassInfo classInfo, Object instance, Map.Entry<String, Object> property) {
        FieldInfo fieldInfo;
        PropertyWriter writer = this.entityAccessStrategy.getPropertyWriter(classInfo, property.getKey());
        if (writer == null && (fieldInfo = classInfo.relationshipFieldByName(property.getKey())) != null) {
            writer = new FieldWriter(classInfo, fieldInfo);
        }
        if (writer != null) {
            List<Object> value = property.getValue();
            if (value != null && value.getClass().isArray()) {
                value = Arrays.asList((Object[])value);
            }
            if (writer.type().isArray() || Iterable.class.isAssignableFrom(writer.type())) {
                value = writer.type().isArray() ? EntityAccess.merge(writer.type(), (Object)value, new Object[0]) : EntityAccess.merge(writer.type(), (Object)value, Collections.EMPTY_LIST);
            }
            writer.write(instance, value);
        } else {
            logger.warn("Unable to find property: {} on class: {} for writing", (Object)property.getKey(), (Object)classInfo.name());
        }
    }
}

