/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.ogm.model.Property;

public class Utils {
    public static final Map<String, Object> map(final Object ... keysAndValues) {
        return new HashMap<String, Object>(){
            {
                for (int i = 0; i < keysAndValues.length; i += 2) {
                    this.put(String.valueOf(keysAndValues[i]), keysAndValues[i + 1]);
                }
            }
        };
    }

    public static final Map<String, Object> mapCollection(final String collectionName, final Collection<Property<String, Object>> properties) {
        return new HashMap<String, Object>(){
            {
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (Property property : properties) {
                    String key = (String)property.getKey();
                    Object value = property.asParameter();
                    if (value == null) continue;
                    values.put(key, value);
                }
                this.put(collectionName, values);
            }
        };
    }

    public static int size(Iterable<?> iterable) {
        return iterable instanceof Collection ? ((Collection)iterable).size() : Utils.size(iterable.iterator());
    }

    public static int size(Iterator<?> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static Object coerceTypes(Class clazz, Object value) {
        if (clazz.isPrimitive() && value == null) {
            return Utils.defaultForPrimitive(clazz, value);
        }
        if (value != null) {
            String className = clazz.getName();
            if (("int".equals(className) || Integer.class.equals((Object)clazz)) && value.getClass().equals(Long.class)) {
                Long longValue = (Long)value;
                if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException(longValue + " cannot be cast to int without an overflow.");
                }
                return longValue.intValue();
            }
            if ("float".equals(className) || Float.class.equals((Object)clazz)) {
                if (value.getClass().equals(Double.class)) {
                    Double dblValue = (Double)value;
                    if (dblValue < -3.4028234663852886E38 || dblValue > 3.4028234663852886E38) {
                        throw new IllegalArgumentException(dblValue + " cannot be cast to float without an overflow.");
                    }
                    return Float.valueOf(dblValue.floatValue());
                }
                if (value.getClass().equals(Integer.class)) {
                    Integer intValue = (Integer)value;
                    if ((double)intValue.intValue() < -1.7976931348623157E308 || (double)intValue.intValue() > Double.MAX_VALUE) {
                        throw new IllegalArgumentException(intValue + " cannot be cast to float without an overflow.");
                    }
                    return Float.valueOf(intValue.intValue());
                }
                if (value.getClass().equals(Long.class)) {
                    Long longValue = (Long)value;
                    if ((double)longValue.longValue() < -1.7976931348623157E308 || (double)longValue.longValue() > Double.MAX_VALUE) {
                        throw new IllegalArgumentException(longValue + " cannot be cast to float without an overflow.");
                    }
                    return Float.valueOf(longValue.longValue());
                }
            }
            if ("byte".equals(className) || Byte.class.equals((Object)clazz)) {
                if (value.getClass().equals(Integer.class)) {
                    Integer intValue = (Integer)value;
                    if (intValue < -128 || intValue > 127) {
                        throw new IllegalArgumentException(intValue + " cannot be cast to byte without an overflow.");
                    }
                    return intValue.byteValue();
                }
                if (value.getClass().equals(Long.class)) {
                    Long longValue = (Long)value;
                    if (longValue < -128L || longValue > 127L) {
                        throw new IllegalArgumentException(longValue + " cannot be cast to byte without an overflow.");
                    }
                    return longValue.byteValue();
                }
            }
            if ("double".equals(className) || Double.class.equals((Object)clazz)) {
                if (value.getClass().equals(Integer.class)) {
                    Integer intValue = (Integer)value;
                    if ((double)intValue.intValue() < -1.7976931348623157E308 || (double)intValue.intValue() > Double.MAX_VALUE) {
                        throw new IllegalArgumentException(intValue + " cannot be cast to double without an overflow.");
                    }
                    return (double)intValue.intValue();
                }
                if (value.getClass().equals(Long.class)) {
                    Long testValue = (Long)value;
                    if ((double)testValue.longValue() < -1.7976931348623157E308 || (double)testValue.longValue() > Double.MAX_VALUE) {
                        throw new IllegalArgumentException(testValue + " cannot be cast to double without an overflow.");
                    }
                    return (double)testValue.longValue();
                }
                if (value.getClass().equals(Float.class)) {
                    Float floatValue = (Float)value;
                    return (double)floatValue.floatValue();
                }
            }
            if (("long".equals(className) || Long.class.equals((Object)clazz)) && value.getClass().equals(Integer.class)) {
                Integer intValue = (Integer)value;
                return (long)intValue.intValue();
            }
            if ("short".equals(className) || Short.class.equals((Object)clazz)) {
                if (value.getClass().equals(Long.class)) {
                    Long longValue = (Long)value;
                    if (longValue < -32768L || longValue > 32767L) {
                        throw new IllegalArgumentException(longValue + " cannot be cast to short without an overflow.");
                    }
                    return longValue.shortValue();
                }
                if (value.getClass().equals(Integer.class)) {
                    Integer intValue = (Integer)value;
                    if (intValue < Short.MIN_VALUE || intValue > Short.MAX_VALUE) {
                        throw new IllegalArgumentException(intValue + " cannot be cast to short without an overflow.");
                    }
                    return intValue.shortValue();
                }
            }
            if ("char".equals(className) || Character.class.equals((Object)clazz)) {
                if (value.getClass().equals(String.class)) {
                    String stringValue = (String)value;
                    if (stringValue.length() == 1) {
                        return Character.valueOf(stringValue.charAt(0));
                    }
                    try {
                        return Character.valueOf((char)Integer.parseInt(stringValue));
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException(stringValue + " cannot be cast to char");
                    }
                }
                if (value.getClass().equals(Integer.class)) {
                    Integer intValue = (Integer)value;
                    if (intValue < Short.MIN_VALUE || intValue > Short.MAX_VALUE) {
                        throw new IllegalArgumentException(intValue + " cannot be cast to short without an overflow.");
                    }
                    return intValue.shortValue();
                }
            }
        }
        return value;
    }

    private static Object defaultForPrimitive(Class clazz, Object value) {
        String className = clazz.getName();
        if ("int".equals(className) || "byte".equals(className) || "short".equals(className)) {
            return 0;
        }
        if ("double".equals(className)) {
            return 0.0;
        }
        if ("float".equals(className)) {
            return Float.valueOf(0.0f);
        }
        if ("long".equals(className)) {
            return 0L;
        }
        return value;
    }
}

