/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.context.DirectedRelationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntityCollector {
    private final Logger logger = LoggerFactory.getLogger(EntityCollector.class);
    private final Map<Long, Map<DirectedRelationship, Set<Object>>> relationshipCollectibles = new HashMap<Long, Map<DirectedRelationship, Set<Object>>>();

    EntityCollector() {
    }

    public void recordTypeRelationship(Long owningEntityId, Object collectibleElement, String relationshipType, String relationshipDirection) {
        if (this.relationshipCollectibles.get(owningEntityId) == null) {
            this.relationshipCollectibles.put(owningEntityId, new HashMap());
        }
        DirectedRelationship directedRelationship = new DirectedRelationship(relationshipType, relationshipDirection);
        if (this.relationshipCollectibles.get(owningEntityId).get(directedRelationship) == null) {
            this.relationshipCollectibles.get(owningEntityId).put(directedRelationship, new HashSet());
        }
        this.relationshipCollectibles.get(owningEntityId).get(directedRelationship).add(collectibleElement);
    }

    public Iterable<Long> getOwningTypes() {
        return this.relationshipCollectibles.keySet();
    }

    public Iterable<String> getOwningRelationshipTypes(Long owningObjectId) {
        HashSet<String> relTypes = new HashSet<String>();
        for (DirectedRelationship rel : this.relationshipCollectibles.get(owningObjectId).keySet()) {
            relTypes.add(rel.type());
        }
        return relTypes;
    }

    public Iterable<String> getRelationshipDirectionsForOwningTypeAndRelationshipType(Long owningObjectId, String relationshipType) {
        HashSet<String> relDirections = new HashSet<String>();
        for (DirectedRelationship rel : this.relationshipCollectibles.get(owningObjectId).keySet()) {
            if (!rel.type().equals(relationshipType)) continue;
            relDirections.add(rel.direction());
        }
        return relDirections;
    }

    public Set<Object> getCollectiblesForOwnerAndRelationship(Long owningObjectId, String relationshipType, String relationshipDirection) {
        DirectedRelationship directedRelationship = new DirectedRelationship(relationshipType, relationshipDirection);
        return this.relationshipCollectibles.get(owningObjectId).get(directedRelationship);
    }

    public Class getCollectibleTypeForOwnerAndRelationship(Long owningObjectId, String relationshipType, String relationshipDirection) {
        DirectedRelationship directedRelationship = new DirectedRelationship(relationshipType, relationshipDirection);
        return this.relationshipCollectibles.get(owningObjectId).get(directedRelationship).iterator().next().getClass();
    }
}

