/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.annotations;

import org.neo4j.ogm.annotations.MethodWriter;
import org.neo4j.ogm.annotations.PropertyReader;
import org.neo4j.ogm.annotations.RelationalReader;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;

public class MethodReader
implements RelationalReader,
PropertyReader {
    private final ClassInfo classInfo;
    private final MethodInfo methodInfo;

    MethodReader(ClassInfo classInfo, MethodInfo methodInfo) {
        this.classInfo = classInfo;
        this.methodInfo = methodInfo;
    }

    @Override
    public Object read(Object instance) {
        Object value = MethodWriter.read(this.classInfo.getMethod(this.methodInfo, new Class[0]), instance);
        if (this.methodInfo.hasConverter()) {
            value = this.methodInfo.converter().toGraphProperty(value);
        }
        return value;
    }

    @Override
    public String relationshipType() {
        return this.methodInfo.relationship();
    }

    @Override
    public String relationshipDirection() {
        AnnotationInfo relationshipAnnotation;
        ObjectAnnotations annotations = this.methodInfo.getAnnotations();
        if (annotations != null && (relationshipAnnotation = annotations.get("org.neo4j.ogm.annotation.Relationship")) != null) {
            return relationshipAnnotation.get("direction", "UNDIRECTED");
        }
        return "UNDIRECTED";
    }

    @Override
    public String typeParameterDescriptor() {
        return this.methodInfo.getTypeDescriptor();
    }

    @Override
    public String propertyName() {
        return this.methodInfo.property();
    }
}

