/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.annotations;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.neo4j.ogm.annotations.PropertyWriter;
import org.neo4j.ogm.annotations.RelationalWriter;
import org.neo4j.ogm.session.Utils;

public abstract class EntityAccess
implements PropertyWriter,
RelationalWriter {
    public static Object merge(Class<?> parameterType, Object newValues, Object[] currentValues) {
        if (currentValues != null) {
            return EntityAccess.merge(parameterType, newValues, Arrays.asList(currentValues));
        }
        return EntityAccess.merge(parameterType, newValues, new ArrayList());
    }

    public static Object merge(Class<?> parameterType, Object newValues, Iterable<?> currentValues) {
        newValues = EntityAccess.boxPrimitiveArray(newValues);
        newValues = EntityAccess.stringToCharacterIterable(newValues, parameterType);
        if (parameterType.isArray()) {
            Class<?> type = parameterType.getComponentType();
            ArrayList<Object> objects = new ArrayList<Object>(EntityAccess.union((Iterable)newValues, currentValues));
            Object array = Array.newInstance(type, objects.size());
            for (int i = 0; i < objects.size(); ++i) {
                Array.set(array, i, Utils.coerceTypes(type, objects.get(i)));
            }
            return array;
        }
        Collection<?> newCollection = EntityAccess.createCollection(parameterType, (Iterable)newValues, currentValues);
        if (newCollection != null) {
            return newCollection;
        }
        if (parameterType.isAssignableFrom(newValues.getClass())) {
            return newValues;
        }
        throw new RuntimeException("Unsupported: " + parameterType.getName());
    }

    private static Collection<?> createCollection(Class<?> parameterType, Iterable<?> collection, Iterable<?> hydrated) {
        if (Vector.class.isAssignableFrom(parameterType)) {
            return new Vector<Object>(EntityAccess.union(collection, hydrated));
        }
        if (List.class.isAssignableFrom(parameterType)) {
            return new ArrayList<Object>(EntityAccess.union(collection, hydrated));
        }
        if (SortedSet.class.isAssignableFrom(parameterType)) {
            return new TreeSet<Object>(EntityAccess.union(collection, hydrated));
        }
        if (Set.class.isAssignableFrom(parameterType)) {
            return new HashSet<Object>(EntityAccess.union(collection, hydrated));
        }
        return null;
    }

    private static Collection<Object> union(Iterable<?> collection, Iterable<?> hydrated) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : collection) {
            result.add(object);
        }
        if (hydrated != null) {
            for (Object object : hydrated) {
                if (result.contains(object)) continue;
                result.add(object);
            }
        }
        return result;
    }

    private static Object stringToCharacterIterable(Object value, Class parameterType) {
        if (value instanceof String) {
            char[] chars = ((String)value).toCharArray();
            ArrayList<Character> characters = new ArrayList<Character>(chars.length);
            for (char c : chars) {
                characters.add(Character.valueOf(c));
            }
            return characters;
        }
        if (value.getClass().isArray() && parameterType.getComponentType().equals(Character.class) && value.getClass().getComponentType().equals(String.class)) {
            String[] strings = (String[])value;
            ArrayList<Character> characters = new ArrayList<Character>(strings.length);
            for (String s : strings) {
                characters.add(Character.valueOf(s.toCharArray()[0]));
            }
            return characters;
        }
        if (value.getClass().isArray() && parameterType.getComponentType().equals(String.class)) {
            String[] strings = (String[])value;
            return Arrays.asList(strings);
        }
        return value;
    }

    private static Object boxPrimitiveArray(Object value) {
        if (value.getClass().isArray() && value.getClass().getComponentType().isPrimitive()) {
            switch (value.getClass().getComponentType().toString()) {
                case "int": {
                    int[] intArray = (int[])value;
                    ArrayList<Integer> boxedIntList = new ArrayList<Integer>(intArray.length);
                    for (int i : intArray) {
                        boxedIntList.add(i);
                    }
                    return boxedIntList;
                }
                case "float": {
                    float[] floatArray = (float[])value;
                    ArrayList<Float> boxedFloatList = new ArrayList<Float>(floatArray.length);
                    for (float f : floatArray) {
                        boxedFloatList.add(Float.valueOf(f));
                    }
                    return boxedFloatList;
                }
                case "long": {
                    long[] longArray = (long[])value;
                    ArrayList<Long> boxedLongList = new ArrayList<Long>(longArray.length);
                    for (long l : longArray) {
                        boxedLongList.add(l);
                    }
                    return boxedLongList;
                }
                case "double": {
                    double[] dblArray = (double[])value;
                    ArrayList<Double> boxedDoubleList = new ArrayList<Double>(dblArray.length);
                    for (double d : dblArray) {
                        boxedDoubleList.add(d);
                    }
                    return boxedDoubleList;
                }
                case "boolean": {
                    boolean[] booleanArray = (boolean[])value;
                    ArrayList<Boolean> boxedBooleanList = new ArrayList<Boolean>(booleanArray.length);
                    for (boolean b : booleanArray) {
                        boxedBooleanList.add(b);
                    }
                    return boxedBooleanList;
                }
                case "char": {
                    char[] charArray = (char[])value;
                    ArrayList<Character> boxedCharList = new ArrayList<Character>(charArray.length);
                    for (char c : charArray) {
                        boxedCharList.add(Character.valueOf(c));
                    }
                    return boxedCharList;
                }
            }
        }
        return value;
    }
}

